/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.clean;

import de.dagere.peass.ci.clean.Messages;
import de.dagere.peass.ci.clean.callables.CleanMeasurementCallable;
import de.dagere.peass.ci.clean.callables.CleanRCACallable;
import de.dagere.peass.ci.clean.callables.CleanRTSCallable;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class CleanBuilder
extends Builder
implements SimpleBuildStep,
Serializable {
    private static final long serialVersionUID = 9194518872489989179L;
    private boolean cleanRTS = true;
    private boolean cleanMeasurement = true;
    private boolean cleanRCA = true;

    @DataBoundConstructor
    public CleanBuilder() {
    }

    public void perform(Run<?, ?> run, FilePath workspace, EnvVars env, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        boolean worked;
        listener.getLogger().println("Cleaning");
        File localWorkspace = new File(run.getRootDir(), ".." + File.separator + ".." + File.separator + "peass-data").getCanonicalFile();
        String projectName = new File(workspace.getRemote()).getName();
        if (this.cleanRTS) {
            worked = (Boolean)workspace.act((FilePath.FileCallable)new CleanRTSCallable(listener));
            if (!worked) {
                run.setResult(Result.FAILURE);
                return;
            }
            CleanRTSCallable.cleanFolder(projectName, localWorkspace);
        } else {
            listener.getLogger().println("Regression Test Selection cleaning disabled");
        }
        if (this.cleanMeasurement) {
            worked = (Boolean)workspace.act((FilePath.FileCallable)new CleanMeasurementCallable(listener));
            if (!worked) {
                run.setResult(Result.FAILURE);
                return;
            }
            CleanMeasurementCallable.cleanFolder(projectName, localWorkspace);
        } else {
            listener.getLogger().println("Measurement cleaning disabled");
        }
        if (this.cleanRCA) {
            worked = (Boolean)workspace.act((FilePath.FileCallable)new CleanRCACallable(listener));
            if (!worked) {
                run.setResult(Result.FAILURE);
                return;
            }
            CleanRCACallable.cleanFolder(projectName, localWorkspace);
        } else {
            listener.getLogger().println("RCA cleaning disabled");
        }
    }

    public boolean isCleanRTS() {
        return this.cleanRTS;
    }

    @DataBoundSetter
    public void setCleanRTS(boolean cleanRTS) {
        this.cleanRTS = cleanRTS;
    }

    public boolean isCleanMeasurement() {
        return this.cleanMeasurement;
    }

    @DataBoundSetter
    public void setCleanMeasurement(boolean cleanMeasurement) {
        this.cleanMeasurement = cleanMeasurement;
    }

    public boolean isCleanRCA() {
        return this.cleanRCA;
    }

    @DataBoundSetter
    public void setCleanRCA(boolean cleanRCA) {
        this.cleanRCA = cleanRCA;
    }

    @Symbol(value={"cleanPerformanceMeasurement"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public FormValidation doCheckName(@QueryParameter String value, @QueryParameter boolean useFrench) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)("Strange value: " + value));
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.Clean_DescriptorImpl_DisplayName();
        }
    }
}

