/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.clean.callables;

import de.dagere.peass.ci.clean.callables.CleanUtil;
import de.dagere.peass.ci.process.JenkinsLogRedirector;
import de.dagere.peass.folders.ResultsFolders;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import io.jenkins.cli.shaded.org.apache.commons.io.filefilter.WildcardFileFilter;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.remoting.RoleChecker;

public class CleanMeasurementCallable
implements FilePath.FileCallable<Boolean> {
    private static final long serialVersionUID = 4804971173610549315L;
    private final TaskListener listener;

    public CleanMeasurementCallable(TaskListener listener) {
        this.listener = listener;
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
    }

    public Boolean invoke(File potentialSlaveWorkspace, VirtualChannel channel) {
        JenkinsLogRedirector redirector = new JenkinsLogRedirector(this.listener);
        try {
            String projectName = potentialSlaveWorkspace.getName();
            File folder = new File(potentialSlaveWorkspace.getParentFile(), projectName + "_fullPeass");
            ResultsFolders resultsFolders = new ResultsFolders(folder, projectName);
            CleanMeasurementCallable.deleteAllMeasurementData(projectName, folder, resultsFolders);
            Boolean bl = true;
            redirector.close();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                try {
                    redirector.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.listener.getLogger().println("Exception thrown");
                e.printStackTrace(this.listener.getLogger());
                e.printStackTrace();
                return false;
            }
        }
    }

    public static void cleanFolder(String projectName, File folder) throws IOException {
        System.out.println("Trying " + folder + " " + projectName);
        ResultsFolders resultsFolders = new ResultsFolders(folder, projectName);
        File trendFile = new File(folder, "trend.json");
        if (trendFile.exists()) {
            System.out.println("Deleting " + trendFile);
            System.out.println("Success: " + trendFile.delete());
        }
        CleanMeasurementCallable.deleteAllMeasurementData(projectName, folder, resultsFolders);
    }

    private static void deleteAllMeasurementData(String projectName, File folder, ResultsFolders resultsFolders) throws IOException {
        CleanMeasurementCallable.deleteResultFiles(resultsFolders);
        CleanMeasurementCallable.deleteLogFolders(resultsFolders);
        CleanUtil.cleanProjectFolder(folder, projectName);
        CleanMeasurementCallable.deleteCopiedFolders(folder);
    }

    private static void deleteCopiedFolders(File folder) throws IOException {
        File[] measurementFolders = folder.listFiles((FileFilter)new WildcardFileFilter("measurement_*"));
        if (measurementFolders != null) {
            for (File oldMeasurementFolder : measurementFolders) {
                System.out.println("Deleting: " + oldMeasurementFolder);
                FileUtils.deleteDirectory((File)oldMeasurementFolder);
            }
        }
    }

    private static void deleteResultFiles(ResultsFolders resultsFolders) throws IOException {
        System.out.println("Deleting " + resultsFolders.getChangeFile());
        System.out.println("Success: " + resultsFolders.getChangeFile().delete());
        System.out.println("Deleting " + resultsFolders.getStatisticsFile());
        System.out.println("Success: " + resultsFolders.getStatisticsFile().delete());
    }

    private static void deleteLogFolders(ResultsFolders resultsFolders) throws IOException {
        System.out.println("Deleting " + resultsFolders.getMeasurementLogFolder());
        FileUtils.deleteDirectory((File)resultsFolders.getMeasurementLogFolder());
    }
}

