/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.clean.callables;

import de.dagere.peass.ci.process.JenkinsLogRedirector;
import de.dagere.peass.folders.CauseSearchFolders;
import de.dagere.peass.folders.ResultsFolders;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.remoting.RoleChecker;

public class CleanRCACallable
implements FilePath.FileCallable<Boolean> {
    private static final long serialVersionUID = 2008970638274618905L;
    private final TaskListener listener;

    public CleanRCACallable(TaskListener listener) {
        this.listener = listener;
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
    }

    public Boolean invoke(File potentialSlaveWorkspace, VirtualChannel channel) throws IOException, InterruptedException {
        JenkinsLogRedirector redirector = new JenkinsLogRedirector(this.listener);
        try {
            String projectName = potentialSlaveWorkspace.getName();
            File folder = new File(potentialSlaveWorkspace.getParentFile(), projectName + "_fullPeass");
            CleanRCACallable.cleanFolder(projectName, folder);
            Boolean bl = true;
            redirector.close();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                try {
                    redirector.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.listener.getLogger().println("Exception thrown");
                e.printStackTrace(this.listener.getLogger());
                e.printStackTrace();
                return false;
            }
        }
    }

    public static void cleanFolder(String projectName, File folder) throws IOException {
        System.out.println("Trying " + folder + " " + projectName);
        ResultsFolders resultsFolders = new ResultsFolders(folder, projectName);
        File visualizationFolder = new File(folder, "visualization");
        if (visualizationFolder.exists()) {
            System.out.println("Deleting " + visualizationFolder);
            FileUtils.deleteDirectory((File)visualizationFolder);
        }
        CleanRCACallable.deleteRCALogFolder(resultsFolders);
    }

    private static void deleteRCALogFolder(ResultsFolders resultsFolders) throws IOException {
        System.out.println("Deleting " + resultsFolders.getRCALogFolder());
        FileUtils.deleteDirectory((File)resultsFolders.getRCALogFolder());
        CauseSearchFolders folders = resultsFolders.getPeassFolders();
        if (folders != null) {
            if (folders.getRcaFolder().exists()) {
                System.out.println("Deleting: " + folders.getRcaFolder());
                FileUtils.cleanDirectory((File)folders.getRcaFolder());
            }
            System.out.println("Deleting: " + folders.getRCALogFolder());
            FileUtils.cleanDirectory((File)folders.getRCALogFolder());
        } else {
            System.err.println("Project folder " + resultsFolders.getPeassFolders() + " was not existing - not cleaning");
        }
    }
}

