/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.clean.callables;

import de.dagere.peass.ci.clean.callables.CleanUtil;
import de.dagere.peass.ci.process.JenkinsLogRedirector;
import de.dagere.peass.folders.ResultsFolders;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.remoting.RoleChecker;

public class CleanRTSCallable
implements FilePath.FileCallable<Boolean> {
    private static final long serialVersionUID = 6370053198339266977L;
    private final TaskListener listener;

    public CleanRTSCallable(TaskListener listener) {
        this.listener = listener;
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
    }

    public Boolean invoke(File potentialSlaveWorkspace, VirtualChannel channel) throws IOException, InterruptedException {
        JenkinsLogRedirector redirector = new JenkinsLogRedirector(this.listener);
        try {
            String projectName = potentialSlaveWorkspace.getName();
            File folder = new File(potentialSlaveWorkspace.getParentFile(), projectName + "_fullPeass");
            ResultsFolders resultsFolders = new ResultsFolders(folder, projectName);
            CleanRTSCallable.deleteResultFiles(resultsFolders);
            CleanRTSCallable.deleteLogFolders(resultsFolders);
            CleanUtil.cleanProjectFolder(folder, projectName);
            Boolean bl = true;
            redirector.close();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                try {
                    redirector.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.listener.getLogger().println("Exception thrown");
                e.printStackTrace(this.listener.getLogger());
                e.printStackTrace();
                return false;
            }
        }
    }

    public static void cleanFolder(String projectName, File folder) throws IOException {
        System.out.println("Trying " + folder + " " + projectName);
        ResultsFolders resultsFolders = new ResultsFolders(folder, projectName);
        CleanRTSCallable.deleteResultFiles(resultsFolders);
        CleanRTSCallable.deleteLogFolders(resultsFolders);
    }

    private static void deleteResultFiles(ResultsFolders resultsFolders) throws IOException {
        System.out.println("Deleting " + resultsFolders.getStaticTestSelectionFile());
        System.out.println("Success: " + resultsFolders.getStaticTestSelectionFile().delete());
        System.out.println("Deleting " + resultsFolders.getTraceTestSelectionFile());
        System.out.println("Success: " + resultsFolders.getTraceTestSelectionFile().delete());
        System.out.println("Deleting " + resultsFolders.getCoverageSelectionFile());
        System.out.println("Success: " + resultsFolders.getCoverageSelectionFile().delete());
        System.out.println("Deleting " + resultsFolders.getCoverageInfoFile());
        System.out.println("Success: " + resultsFolders.getCoverageInfoFile().delete());
        System.out.println("Deleting " + resultsFolders.getViewFolder());
        FileUtils.deleteDirectory((File)resultsFolders.getViewFolder());
        System.out.println("Deleting " + resultsFolders.getPropertiesFolder());
        FileUtils.deleteDirectory((File)resultsFolders.getPropertiesFolder());
    }

    private static void deleteLogFolders(ResultsFolders resultsFolders) throws IOException {
        System.out.println("Deleting " + resultsFolders.getRtsLogFolder());
        FileUtils.deleteDirectory((File)resultsFolders.getRtsLogFolder());
        System.out.println("Deleting " + resultsFolders.getSourceReadLogFolder());
        FileUtils.deleteDirectory((File)resultsFolders.getSourceReadLogFolder());
    }
}

