/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.helper;

import com.google.common.io.Files;
import de.dagere.kopeme.datastorage.JSONDataLoader;
import de.dagere.kopeme.kopemedata.Kopemedata;
import de.dagere.peass.ci.MeasurementVisualizationAction;
import de.dagere.peass.ci.helper.IdHelper;
import de.dagere.peass.ci.helper.VisualizationFolderManager;
import de.dagere.peass.ci.rca.RCAVisualizer;
import de.dagere.peass.dependency.analysis.testData.TestMethodCall;
import de.dagere.peass.measurement.statistics.data.TestcaseStatistic;
import de.dagere.peass.utils.Constants;
import de.dagere.peass.visualization.GraphNode;
import de.dagere.peass.visualization.KoPeMeTreeConverter;
import hudson.model.Action;
import hudson.model.Run;
import io.jenkins.cli.shaded.org.apache.commons.io.filefilter.WildcardFileFilter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultMeasurementVisualizer {
    private static final Logger LOG = LogManager.getLogger(DefaultMeasurementVisualizer.class);
    private final File dataFolder;
    private final String commit;
    private final Run<?, ?> run;
    private final VisualizationFolderManager visualizationFolders;
    private final Set<String> tests;
    private final Map<String, TestcaseStatistic> noWarmupStatistics = new HashMap<String, TestcaseStatistic>();

    public DefaultMeasurementVisualizer(File dataFolder, String version, Run<?, ?> run, VisualizationFolderManager visualizationFolders, Set<String> tests) {
        this.dataFolder = dataFolder;
        this.commit = version;
        this.run = run;
        this.visualizationFolders = visualizationFolders;
        this.tests = tests;
    }

    public void visualizeMeasurements() {
        String longestPrefix = RCAVisualizer.getLongestPrefix(this.tests);
        LOG.debug("Prefix: {} Keys: {}", (Object)longestPrefix, this.tests);
        File detailResultsFolder = new File(this.dataFolder, "measurements");
        File[] files = this.dataFolder.listFiles((FileFilter)new WildcardFileFilter("*.json"));
        LOG.debug("Searching in {} Files: {}", (Object)this.dataFolder, files != null ? Integer.valueOf(files.length) : "no files");
        this.readFiles(longestPrefix, detailResultsFolder, files);
    }

    private void readFiles(String longestPrefix, File detailResultsFolder, File[] files) {
        if (files != null) {
            Arrays.sort(files);
            for (File testcaseFile : files) {
                try {
                    Kopemedata data = JSONDataLoader.loadData((File)testcaseFile);
                    TestMethodCall testcase = new TestMethodCall(data);
                    KoPeMeTreeConverter treeConverter = new KoPeMeTreeConverter(detailResultsFolder, this.commit, testcase);
                    File testcaseVisualizationFile = this.generateJSFile(testcase, treeConverter);
                    if (testcaseVisualizationFile == null) continue;
                    LOG.debug("Adding action: " + testcase.toString());
                    String name = testcase.toString().replace("#", "_").substring(longestPrefix.length());
                    String content = FileUtils.readFileToString((File)testcaseVisualizationFile, (Charset)StandardCharsets.UTF_8);
                    this.run.addAction((Action)new MeasurementVisualizationAction(IdHelper.getId(), "measurement_" + name, content));
                }
                catch (IOException | NumberIsTooSmallException e) {
                    LOG.error((Object)e);
                }
            }
        }
    }

    public Map<String, TestcaseStatistic> getNoWarmupStatistics() {
        return this.noWarmupStatistics;
    }

    private File generateJSFile(TestMethodCall testcase, KoPeMeTreeConverter treeConverter) throws IOException {
        GraphNode kopemeDataNode = treeConverter.getData();
        if (kopemeDataNode != null) {
            LOG.info("Statistic: {}", (Object)kopemeDataNode.getStatistic());
            this.noWarmupStatistics.put(testcase.toString(), kopemeDataNode.getStatistic());
            File versionVisualizationFolder = new File(this.visualizationFolders.getVisualizationFolder(), this.commit);
            File kopemeVisualizationFolder = new File(versionVisualizationFolder, "pure_kopeme");
            if (!kopemeVisualizationFolder.mkdirs()) {
                LOG.error("Creating file {} was not possibley", (Object)kopemeVisualizationFolder);
            }
            File testcaseVisualizationFile = new File(kopemeVisualizationFolder, testcase.getClazz() + "_" + testcase.getMethodWithParams() + ".json");
            this.writeDataJS(testcaseVisualizationFile, kopemeDataNode);
            return testcaseVisualizationFile;
        }
        LOG.error("Testcase {} could not be found", (Object)testcase);
        return null;
    }

    private void writeDataJS(File destFile, GraphNode kopemeDataNode) throws IOException {
        try (BufferedWriter fileWriter = Files.newWriter((File)destFile, (Charset)StandardCharsets.UTF_8);){
            fileWriter.write("var treeData = {};\n\n");
            fileWriter.write("var kopemeData = [\n");
            fileWriter.write(Constants.OBJECTMAPPER.writeValueAsString((Object)kopemeDataNode));
            fileWriter.write("];\n");
        }
    }
}

