/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.helper;

import de.dagere.kopeme.datastorage.JSONDataLoader;
import de.dagere.kopeme.kopemedata.DatacollectorResult;
import de.dagere.kopeme.kopemedata.Kopemedata;
import de.dagere.kopeme.kopemedata.TestMethod;
import de.dagere.kopeme.kopemedata.VMResultChunk;
import de.dagere.peass.ci.helper.HistogramValues;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.dependency.analysis.testData.TestMethodCall;
import de.dagere.peass.measurement.dataloading.MultipleVMTestUtil;
import de.dagere.peass.measurement.dataloading.ResultLoader;
import io.jenkins.cli.shaded.org.apache.commons.io.filefilter.WildcardFileFilter;
import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class HistogramReader {
    private final MeasurementConfig measurementConfig;
    private final File fullResultsFolder;
    private Map<String, MeasurementConfig> updatedConfigurations = new HashMap<String, MeasurementConfig>();

    public HistogramReader(MeasurementConfig measurementConfig, File fullResultsFolder) {
        this.measurementConfig = measurementConfig;
        this.fullResultsFolder = fullResultsFolder;
    }

    public Map<String, HistogramValues> readMeasurements() {
        TreeMap<String, HistogramValues> measurements = new TreeMap<String, HistogramValues>();
        if (this.fullResultsFolder.exists() && this.fullResultsFolder.isDirectory()) {
            File[] xmlFiles = this.fullResultsFolder.listFiles((FileFilter)new WildcardFileFilter("*.json"));
            if (xmlFiles == null) {
                System.out.println("No json-Files were found, measurements is empty!");
                return measurements;
            }
            for (File xmlResultFile : xmlFiles) {
                this.readFile(measurements, xmlResultFile);
            }
        }
        return measurements;
    }

    public Map<String, MeasurementConfig> getUpdatedConfigurations() {
        return this.updatedConfigurations;
    }

    private void readFile(Map<String, HistogramValues> measurements, File xmlResultFile) {
        boolean moreThanOneMeasurement;
        String testcaseKey;
        MeasurementConfig currentConfig;
        Kopemedata data = JSONDataLoader.loadData((File)xmlResultFile);
        TestMethod testcase = (TestMethod)data.getMethods().get(0);
        VMResultChunk chunk = (VMResultChunk)((DatacollectorResult)testcase.getDatacollectorResults().get(0)).getChunks().get(0);
        HistogramValues values = this.loadResults(chunk, currentConfig = this.getUpdatedConfiguration(testcaseKey = new TestMethodCall(data).toString(), testcase, chunk));
        boolean bl = moreThanOneMeasurement = values.getValuesCurrent().length > 1 && values.getValuesBefore().length > 1;
        if (moreThanOneMeasurement) {
            measurements.put(testcaseKey, values);
        }
    }

    private HistogramValues loadResults(VMResultChunk chunk, MeasurementConfig currentConfig) {
        ResultLoader loader = new ResultLoader(currentConfig);
        loader.loadChunk(chunk);
        HistogramValues values = new HistogramValues(loader.getValsBefore(), loader.getValsAfter(), currentConfig);
        return values;
    }

    private MeasurementConfig getUpdatedConfiguration(String testcaseKey, TestMethod testcase, VMResultChunk chunk) {
        MeasurementConfig currentConfig = new MeasurementConfig(this.measurementConfig);
        int iterations = (int)MultipleVMTestUtil.getMinIterationCount((List)chunk.getResults());
        if (iterations != currentConfig.getAllIterations()) {
            currentConfig.setIterations((int)Math.ceil((double)iterations / 2.0));
            currentConfig.setWarmup(iterations / 2);
        }
        currentConfig.setRepetitions((int)MultipleVMTestUtil.getMinRepetitionCount((List)chunk.getResults()));
        if (currentConfig.getAllIterations() != this.measurementConfig.getAllIterations() || currentConfig.getRepetitions() != this.measurementConfig.getRepetitions()) {
            this.updatedConfigurations.put(testcaseKey, currentConfig);
        }
        return currentConfig;
    }

    public boolean measurementConfigurationUpdated() {
        return !this.updatedConfigurations.isEmpty();
    }
}

