/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.helper;

public class UnitConverter {
    public static final int NANOSECONDS_TO_MICROSECONDS = 1000;
    public static final int NANOSECONDS_TO_MILLISECONDS = 1000000;
    public static final int NANOSECONDS_TO_SECONDS = 1000000000;
    public static final String NANOSECONDS = "ns";
    public static final String MICROSECONDS = "\u00b5s";
    public static final String MILLISECONDS = "ms";
    public static final String SECONDS = "s";

    public static int getFactorByMean(double mean) {
        int count;
        for (count = 0; count < 3 && mean >= 1000.0; mean /= 1000.0, ++count) {
        }
        return UnitConverter.getFactorByCount(count);
    }

    private static int getFactorByCount(int count) {
        switch (count) {
            case 0: {
                return 1;
            }
            case 1: {
                return 1000;
            }
            case 2: {
                return 1000000;
            }
            case 3: {
                return 1000000000;
            }
        }
        return 0;
    }

    public static String getUnitByFactor(int factor) {
        switch (factor) {
            case 1: {
                return NANOSECONDS;
            }
            case 1000: {
                return MICROSECONDS;
            }
            case 1000000: {
                return MILLISECONDS;
            }
            case 1000000000: {
                return SECONDS;
            }
        }
        return "unknown factor provided!";
    }
}

