/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.helper;

import de.dagere.peass.folders.CauseSearchFolders;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.folders.ResultsFolders;
import hudson.model.Run;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VisualizationFolderManager {
    public static final String VISUALIZATION_FOLDER_NAME = "visualization";
    private static final Logger LOG = LogManager.getLogger(VisualizationFolderManager.class);
    private final File localWorkspace;
    private final String projectName;
    private final Run<?, ?> run;

    public VisualizationFolderManager(File localWorkspace, String projectName, Run<?, ?> run) {
        this.localWorkspace = localWorkspace;
        this.run = run;
        this.projectName = projectName;
        LOG.debug("Workspace name: " + projectName);
    }

    public File getPropertyFolder() {
        File propertyFolder = new File(this.localWorkspace, "properties_" + this.projectName);
        if (!propertyFolder.exists()) {
            propertyFolder = new File(this.localWorkspace, "properties_workspace");
        }
        return propertyFolder;
    }

    public File getRcaResultFolder() {
        File rcaResults = new File(this.run.getRootDir(), "rca_visualization");
        if (!rcaResults.exists() && !rcaResults.mkdirs()) {
            throw new RuntimeException("Could not create " + rcaResults.getAbsolutePath());
        }
        return rcaResults;
    }

    public File getDataFolder() {
        String rcaResultFolder = this.projectName + "_peass";
        File dataFolder = new File(this.localWorkspace, rcaResultFolder);
        if (!dataFolder.exists() && !(dataFolder = new File(this.localWorkspace, "workspace_peass")).exists()) {
            this.debugListFiles();
            throw new RuntimeException(this.localWorkspace.getAbsolutePath() + " neither contains workspace_peass nor " + rcaResultFolder + "; one must exist for visualization!");
        }
        return dataFolder;
    }

    public PeassFolders getPeassFolders() {
        File projectFolder = new File(this.localWorkspace, this.projectName);
        if (!projectFolder.exists()) {
            projectFolder = new File(this.localWorkspace, "workspace");
            if (!projectFolder.exists()) {
                this.debugListFiles();
                throw new RuntimeException(this.localWorkspace.getAbsolutePath() + " neither contains workspace_peass nor " + this.projectName + "; one must exist for visualization!");
            }
            return new PeassFolders(projectFolder, "workspace");
        }
        return new PeassFolders(projectFolder, this.projectName);
    }

    public CauseSearchFolders getPeassRCAFolders() {
        File projectFolder = new File(this.localWorkspace, this.projectName);
        if (!projectFolder.exists()) {
            projectFolder = new File(this.localWorkspace, "workspace");
            if (!projectFolder.exists()) {
                this.debugListFiles();
                throw new RuntimeException(this.localWorkspace.getAbsolutePath() + " neither contains workspace_peass nor " + this.projectName + "; one must exist for visualization!");
            }
            return new CauseSearchFolders(projectFolder);
        }
        return new CauseSearchFolders(projectFolder);
    }

    public ResultsFolders getResultsFolders() {
        File projectFolder = new File(this.localWorkspace, this.projectName);
        if (!projectFolder.exists()) {
            projectFolder = new File(this.localWorkspace, "workspace");
            if (!projectFolder.exists()) {
                this.debugListFiles();
                throw new RuntimeException(this.localWorkspace.getAbsolutePath() + " neither contains workspace_peass nor " + this.projectName + "; one must exist for visualization!");
            }
            return new ResultsFolders(this.localWorkspace, "workspace");
        }
        return new ResultsFolders(this.localWorkspace, this.projectName);
    }

    private void debugListFiles() {
        File[] files = this.localWorkspace.listFiles();
        if (files != null) {
            LOG.debug("Files: {}", (Object)files.length);
            for (File file : files) {
                LOG.info("Existing file: {}", (Object)file.getAbsolutePath());
            }
        } else {
            LOG.error("Local workspace did not contain anything");
        }
    }

    public File getVisualizationFolder() {
        File visualizationFolder = new File(this.localWorkspace, VISUALIZATION_FOLDER_NAME);
        if (!visualizationFolder.exists() && !visualizationFolder.mkdirs()) {
            throw new RuntimeException("Could not create " + visualizationFolder.getAbsolutePath());
        }
        return visualizationFolder;
    }
}

