/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.logs;

import de.dagere.kopeme.datastorage.JSONDataLoader;
import de.dagere.kopeme.kopemedata.DatacollectorResult;
import de.dagere.kopeme.kopemedata.Kopemedata;
import de.dagere.peass.ci.helper.VisualizationFolderManager;
import de.dagere.peass.config.FixedCommitConfig;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.dependency.analysis.testData.TestMethodCall;
import de.dagere.peass.folders.PeassFolders;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CorrectRunChecker {
    private static final Logger LOG = LogManager.getLogger(CorrectRunChecker.class);
    boolean currentRunning = false;
    boolean predecessorRunning = false;

    public CorrectRunChecker(TestMethodCall testcase, int vmId, MeasurementConfig measurementConfig, VisualizationFolderManager visualizationFolders) {
        File basicResultFolder = visualizationFolders.getResultsFolders().getVersionFullResultsFolder(measurementConfig);
        File detailResultsFolder = new File(basicResultFolder, "measurements");
        FixedCommitConfig fixedCommitConfig = measurementConfig.getFixedCommitConfig();
        String pathCurrent = PeassFolders.getRelativeFullResultPath((TestMethodCall)testcase, (String)fixedCommitConfig.getCommit(), (String)fixedCommitConfig.getCommit(), (int)vmId);
        File resultFileCurrent = new File(detailResultsFolder, pathCurrent);
        this.currentRunning = this.checkIsRunning(vmId, resultFileCurrent);
        String pathPredecessor = PeassFolders.getRelativeFullResultPath((TestMethodCall)testcase, (String)fixedCommitConfig.getCommit(), (String)fixedCommitConfig.getCommitOld(), (int)vmId);
        File resultFilePredecessor = new File(detailResultsFolder, pathPredecessor);
        this.predecessorRunning = this.checkIsRunning(vmId, resultFilePredecessor);
    }

    private boolean checkIsRunning(int vmId, File resultFileCurrent) {
        boolean isRunning = false;
        if (resultFileCurrent.exists()) {
            LOG.debug("Checking: {} - {} ", (Object)vmId, (Object)resultFileCurrent.getAbsolutePath());
            Kopemedata data = JSONDataLoader.loadData((File)resultFileCurrent);
            DatacollectorResult datacollector = data.getFirstTimeDataCollector();
            if (datacollector.getResults().get(0) != null) {
                isRunning = true;
                LOG.debug("File and result are existing - success");
            }
        } else {
            LOG.debug("File {} missing", (Object)resultFileCurrent);
        }
        return isRunning;
    }

    public boolean isCurrentRunning() {
        return this.currentRunning;
    }

    public boolean isPredecessorRunning() {
        return this.predecessorRunning;
    }
}

