/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.logs;

import de.dagere.peass.ci.PeassProcessConfiguration;
import de.dagere.peass.ci.helper.VisualizationFolderManager;
import de.dagere.peass.ci.logs.LogFileReader;
import de.dagere.peass.ci.logs.RTSLogFileReader;
import de.dagere.peass.ci.logs.measurement.MeasurementActionCreator;
import de.dagere.peass.ci.logs.rca.RCAActionCreator;
import de.dagere.peass.ci.logs.rts.RTSActionCreator;
import de.dagere.peass.ci.logs.rts.RTSLogSummary;
import de.dagere.peass.ci.process.RTSInfos;
import de.dagere.peass.dependency.analysis.testData.TestMethodCall;
import hudson.model.Run;
import java.io.IOException;
import java.util.Set;

public class LogActionCreator {
    private final PeassProcessConfiguration peassConfig;
    private final Run<?, ?> run;
    private final LogFileReader reader;
    private final VisualizationFolderManager visualizationFolders;

    public LogActionCreator(PeassProcessConfiguration peassConfig, Run<?, ?> run, VisualizationFolderManager visualizationFolders) {
        this.peassConfig = peassConfig;
        this.run = run;
        this.visualizationFolders = visualizationFolders;
        this.reader = new LogFileReader(visualizationFolders, peassConfig);
    }

    public RTSLogSummary createRTSActions(RTSInfos staticChanges) throws IOException {
        RTSLogFileReader rtsReader = new RTSLogFileReader(this.visualizationFolders, this.peassConfig);
        RTSActionCreator rtsActionCreator = new RTSActionCreator(rtsReader, this.run, this.peassConfig);
        rtsActionCreator.createRTSActions(staticChanges);
        return rtsActionCreator.getLogSummary();
    }

    public void createMeasurementActions(Set<TestMethodCall> tests) throws IOException {
        MeasurementActionCreator measurementActionCreator = new MeasurementActionCreator(this.reader, this.run, this.peassConfig);
        measurementActionCreator.createMeasurementActions(tests);
    }

    public void createRCAActions() throws IOException {
        RCAActionCreator rcaActionCreator = new RCAActionCreator(this.reader, this.run, this.peassConfig);
        rcaActionCreator.createRCAActions();
    }
}

