/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.logs;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import de.dagere.peass.ci.PeassProcessConfiguration;
import de.dagere.peass.ci.helper.VisualizationFolderManager;
import de.dagere.peass.ci.logs.CorrectRunChecker;
import de.dagere.peass.ci.logs.LogFiles;
import de.dagere.peass.ci.logs.rca.RCALevel;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.dependency.analysis.data.TestCase;
import de.dagere.peass.dependency.analysis.testData.TestMethodCall;
import de.dagere.peass.folders.CauseSearchFolders;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.measurement.rca.data.CauseSearchData;
import de.dagere.peass.utils.Constants;
import io.jenkins.cli.shaded.org.apache.commons.io.filefilter.WildcardFileFilter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogFileReader {
    private static final Logger LOG = LogManager.getLogger(LogFileReader.class);
    private final VisualizationFolderManager visualizationFolders;
    private final PeassProcessConfiguration processConfig;
    private final MeasurementConfig measurementConfig;

    public LogFileReader(VisualizationFolderManager visualizationFolders, PeassProcessConfiguration processConfig) {
        this.visualizationFolders = visualizationFolders;
        this.processConfig = processConfig;
        this.measurementConfig = processConfig.getMeasurementConfig();
    }

    public Map<TestCase, List<LogFiles>> readAllTestcases(Set<TestMethodCall> tests) {
        HashMap<TestCase, List<LogFiles>> logFiles = new HashMap<TestCase, List<LogFiles>>();
        for (TestMethodCall testcase : tests) {
            this.readTestcase(this.visualizationFolders.getPeassFolders(), logFiles, testcase);
        }
        return logFiles;
    }

    public Map<TestCase, List<LogFiles>> readAllRCATestcases() {
        HashMap<TestCase, List<LogFiles>> logFiles = new HashMap<TestCase, List<LogFiles>>();
        return logFiles;
    }

    private void readTestcase(PeassFolders folders, Map<TestCase, List<LogFiles>> logFiles, TestMethodCall testcase) {
        LOG.info("Reading testcase " + testcase);
        File logFolder = folders.getExistingMeasureLogFolder(this.measurementConfig.getFixedCommitConfig().getCommit(), testcase);
        List<LogFiles> currentFiles = this.tryLocalLogFolderVMIds(testcase, logFolder, folders);
        logFiles.put((TestCase)testcase, currentFiles);
    }

    private List<LogFiles> tryLocalLogFolderVMIds(TestMethodCall testcase, File logFolder, PeassFolders folders) {
        LinkedList<LogFiles> currentFiles = new LinkedList<LogFiles>();
        if (logFolder != null && logFolder.exists() && logFolder.isDirectory()) {
            LOG.debug("Log folder: {} {}", (Object)logFolder, (Object)logFolder.listFiles());
            int tryIndex = 0;
            String filenameSuffix = "log_" + testcase.getClazz() + File.separator + testcase.getMethodWithParams() + ".txt";
            File predecessorFile = this.getCommitFile((TestCase)testcase, logFolder, tryIndex, filenameSuffix, this.measurementConfig.getFixedCommitConfig().getCommitOld());
            LOG.debug("Trying whether {} exists {}", (Object)predecessorFile, (Object)predecessorFile.exists());
            while (predecessorFile.exists()) {
                CorrectRunChecker checker = new CorrectRunChecker(testcase, tryIndex, this.measurementConfig, this.visualizationFolders);
                File currentFile = this.getCommitFile((TestCase)testcase, logFolder, tryIndex, filenameSuffix, this.measurementConfig.getFixedCommitConfig().getCommit());
                LogFiles vmidLogFile = new LogFiles(predecessorFile, currentFile, checker.isPredecessorRunning(), checker.isCurrentRunning());
                currentFiles.add(vmidLogFile);
                predecessorFile = this.getCommitFile((TestCase)testcase, logFolder, ++tryIndex, filenameSuffix, this.measurementConfig.getFixedCommitConfig().getCommitOld());
                LOG.debug("Trying whether {} exists: {}", (Object)predecessorFile, (Object)predecessorFile.exists());
            }
        } else {
            LOG.info("Log folder {} not existing", (Object)logFolder);
        }
        return currentFiles;
    }

    private File getCommitFile(TestCase testcase, File logFolder, int tryIndex, String filenameSuffix, String commit) {
        String vmFolderName = "vm_" + tryIndex + "_" + commit;
        File predecessorFile = testcase.getModule() != null ? new File(logFolder, vmFolderName + File.separator + testcase.getModule() + File.separator + filenameSuffix) : new File(logFolder, vmFolderName + File.separator + filenameSuffix);
        return predecessorFile;
    }

    public String getMeasureLog() {
        File measureLogFile = this.visualizationFolders.getResultsFolders().getMeasurementLogFile(this.measurementConfig.getFixedCommitConfig().getCommit(), this.measurementConfig.getFixedCommitConfig().getCommitOld());
        try {
            if (measureLogFile.exists()) {
                LOG.debug("Reading {}", (Object)measureLogFile.getAbsolutePath());
                String measureLog = this.processConfig.getLogText(measureLogFile);
                return measureLog;
            }
            return "Measurement log not readable; file " + measureLogFile.getAbsolutePath() + " did not exist";
        }
        catch (IOException e) {
            e.printStackTrace();
            return "Measurement log not readable";
        }
    }

    public String getRCALog() {
        File rcaLogFile = this.visualizationFolders.getResultsFolders().getRCALogFile(this.measurementConfig.getFixedCommitConfig().getCommit(), this.measurementConfig.getFixedCommitConfig().getCommitOld());
        try {
            LOG.debug("Reading {}", (Object)rcaLogFile.getAbsolutePath());
            String rcaLog = this.processConfig.getLogText(rcaLogFile);
            return rcaLog;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "Measurement log not readable";
        }
    }

    public Map<TestCase, List<RCALevel>> getRCATestcases() {
        CauseSearchFolders causeFolders = this.visualizationFolders.getPeassRCAFolders();
        File versionTreeFolder = new File(causeFolders.getRcaTreeFolder(), this.measurementConfig.getFixedCommitConfig().getCommit());
        HashMap<TestCase, List<RCALevel>> testcases = new HashMap<TestCase, List<RCALevel>>();
        File[] versionFiles = versionTreeFolder.listFiles();
        if (versionFiles != null) {
            for (File testcaseName : versionFiles) {
                File[] testcaseFiles = testcaseName.listFiles((FilenameFilter)new WildcardFileFilter("*.json"));
                if (testcaseFiles == null) continue;
                for (File jsonFileName : testcaseFiles) {
                    try {
                        LOG.debug("Loading: {}", (Object)jsonFileName.getAbsolutePath());
                        this.readRCATestcase(causeFolders, testcases, jsonFileName);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return testcases;
    }

    private void readRCATestcase(CauseSearchFolders causeFolders, Map<TestCase, List<RCALevel>> testcases, File jsonFileName) throws IOException, JsonParseException, JsonMappingException {
        CauseSearchData data = (CauseSearchData)Constants.OBJECTMAPPER.readValue(jsonFileName, CauseSearchData.class);
        TestMethodCall test = data.getCauseConfig().getTestCase();
        boolean lastHadLogs = true;
        int levelId = 0;
        LinkedList<RCALevel> levels = new LinkedList<RCALevel>();
        while (lastHadLogs) {
            File logFolder = causeFolders.getExistingRCALogFolder(this.measurementConfig.getFixedCommitConfig().getCommit(), test, levelId);
            List<LogFiles> currentFiles = this.tryLocalLogFolderVMIds(test, logFolder, (PeassFolders)causeFolders);
            if (currentFiles.size() > 0) {
                RCALevel level = new RCALevel(currentFiles);
                levels.add(level);
                ++levelId;
                continue;
            }
            lastHadLogs = false;
        }
        testcases.put((TestCase)test, levels);
    }
}

