/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.logs;

import de.dagere.peass.ci.PeassProcessConfiguration;
import de.dagere.peass.ci.helper.VisualizationFolderManager;
import de.dagere.peass.ci.logs.RTSLogFileVersionReader;
import de.dagere.peass.ci.logs.rts.RTSLogData;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.dependency.analysis.data.TestSet;
import de.dagere.peass.dependency.analysis.testData.TestMethodCall;
import de.dagere.peass.dependency.persistence.CommitStaticSelection;
import de.dagere.peass.dependency.persistence.StaticTestSelection;
import de.dagere.peass.utils.Constants;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RTSLogFileReader {
    private static final Logger LOG = LogManager.getLogger(RTSLogFileReader.class);
    private final VisualizationFolderManager visualizationFolders;
    private final PeassProcessConfiguration peassConfig;
    private final MeasurementConfig measurementConfig;
    private final boolean logsExisting;
    private final boolean versionRunWasSuccess;

    public RTSLogFileReader(VisualizationFolderManager visualizationFolders, PeassProcessConfiguration peassConfig) {
        this.visualizationFolders = visualizationFolders;
        this.peassConfig = peassConfig;
        this.measurementConfig = peassConfig.getMeasurementConfig();
        File rtsLogOverviewFile = visualizationFolders.getResultsFolders().getRTSLogFile(this.measurementConfig.getFixedCommitConfig().getCommit(), this.measurementConfig.getFixedCommitConfig().getCommitOld());
        LOG.info("RTS log overview file: {} Exists: {}", (Object)rtsLogOverviewFile, (Object)rtsLogOverviewFile.exists());
        this.logsExisting = rtsLogOverviewFile.exists();
        this.versionRunWasSuccess = this.isVersionRunSuccess(visualizationFolders, this.measurementConfig);
    }

    private boolean isVersionRunSuccess(VisualizationFolderManager visualizationFolders, MeasurementConfig measurementConfig) {
        boolean success = false;
        File dependencyFile = visualizationFolders.getResultsFolders().getStaticTestSelectionFile();
        if (dependencyFile.exists()) {
            try {
                StaticTestSelection dependencies = (StaticTestSelection)Constants.OBJECTMAPPER.readValue(dependencyFile, StaticTestSelection.class);
                CommitStaticSelection commitSelection = (CommitStaticSelection)dependencies.getCommits().get(measurementConfig.getFixedCommitConfig().getCommit());
                if (commitSelection != null) {
                    LOG.debug("Commit run success: {}", (Object)commitSelection.isRunning());
                    success = commitSelection.isRunning();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            LOG.debug("Dependencyfile {} not found, so run was n o success", (Object)dependencyFile);
        }
        return success;
    }

    public boolean isVersionRunWasSuccess() {
        return this.versionRunWasSuccess;
    }

    public boolean isLogsExisting() {
        return this.logsExisting;
    }

    public Map<TestMethodCall, RTSLogData> getRtsVmRuns(String commit, TestSet ignoredTests) {
        File commitFolder = new File(this.visualizationFolders.getPeassFolders().getDependencyLogFolder(), commit);
        File[] allFiles = commitFolder.listFiles();
        LinkedHashMap<File, String> testClazzFolders = new LinkedHashMap<File, String>();
        if (allFiles != null) {
            for (File examinedFolder : allFiles) {
                if (examinedFolder.getName().startsWith("log_")) {
                    testClazzFolders.put(examinedFolder, "");
                    continue;
                }
                if (!examinedFolder.isDirectory()) continue;
                String module = examinedFolder.getName();
                File[] versionFiles = examinedFolder.listFiles((FilenameFilter)new WildcardFileFilter("log_*"));
                if (versionFiles == null) continue;
                for (File testClazzFolder : versionFiles) {
                    testClazzFolders.put(testClazzFolder, module);
                }
            }
        } else {
            LOG.info("Expected rts commit folder {} did not exist", (Object)commitFolder);
        }
        RTSLogFileVersionReader RTSLogFileVersionReader2 = new RTSLogFileVersionReader(this.visualizationFolders, commit);
        return RTSLogFileVersionReader2.getClazzLogs(testClazzFolders, ignoredTests);
    }

    public String getRTSLog() {
        File rtsLogFile = this.visualizationFolders.getResultsFolders().getRTSLogFile(this.measurementConfig.getFixedCommitConfig().getCommit(), this.measurementConfig.getFixedCommitConfig().getCommitOld());
        try {
            LOG.debug("Reading RTS Log {}", (Object)rtsLogFile.getAbsolutePath());
            return this.peassConfig.getLogText(rtsLogFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "RTS log not readable";
        }
    }

    public String getSourceReadingLog() {
        File sourceReadLogFile = this.visualizationFolders.getResultsFolders().getSourceReadLogFile(this.measurementConfig.getFixedCommitConfig().getCommit(), this.measurementConfig.getFixedCommitConfig().getCommitOld());
        try {
            if (sourceReadLogFile.exists()) {
                LOG.debug("Reading Source Read Log {}", (Object)sourceReadLogFile.getAbsolutePath());
                return this.peassConfig.getLogText(sourceReadLogFile);
            }
            LOG.error("No source reading log available");
            return "No source reading log available";
        }
        catch (IOException e) {
            e.printStackTrace();
            return "RTS log not readable";
        }
    }

    public Map<String, File> findProcessSuccessRuns() {
        LinkedHashMap<String, File> commitSuccessTestRuns = new LinkedHashMap<String, File>();
        this.addCommitSuccessRun(commitSuccessTestRuns, this.measurementConfig.getFixedCommitConfig().getCommit());
        this.addCommitSuccessRun(commitSuccessTestRuns, this.measurementConfig.getFixedCommitConfig().getCommitOld());
        return commitSuccessTestRuns;
    }

    private void addCommitSuccessRun(Map<String, File> commitSuccessTestRuns, String checkSuccessRunCommit) {
        File candidate = this.visualizationFolders.getPeassFolders().getDependencyLogSuccessRunFile(checkSuccessRunCommit);
        if (candidate.exists()) {
            LOG.info("RTS process success run {} exists", (Object)candidate.getAbsolutePath());
            commitSuccessTestRuns.put(checkSuccessRunCommit, candidate);
        } else {
            LOG.info("RTS process success run {} did not exist", (Object)candidate.getAbsolutePath());
        }
    }
}

