/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.logs;

import de.dagere.peass.ci.helper.VisualizationFolderManager;
import de.dagere.peass.ci.logs.rts.RTSLogData;
import de.dagere.peass.dependency.analysis.data.TestCase;
import de.dagere.peass.dependency.analysis.data.TestSet;
import de.dagere.peass.dependency.analysis.testData.TestClazzCall;
import de.dagere.peass.dependency.analysis.testData.TestMethodCall;
import de.dagere.peass.dependency.traces.TraceWriter;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RTSLogFileVersionReader {
    private static final Logger LOG = LogManager.getLogger(RTSLogFileVersionReader.class);
    private final VisualizationFolderManager visualizationFolders;
    private final String commit;
    private final Map<TestMethodCall, RTSLogData> files = new LinkedHashMap<TestMethodCall, RTSLogData>();
    private File testClazzFolder;
    private File methodFile;
    private TestMethodCall test;

    public RTSLogFileVersionReader(VisualizationFolderManager visualizationFolders, String commit) {
        this.visualizationFolders = visualizationFolders;
        this.commit = commit;
    }

    public Map<TestMethodCall, RTSLogData> getClazzLogs(Map<File, String> testClazzFolders, TestSet ignoredTests) {
        for (Map.Entry<File, String> testClazzFolder : testClazzFolders.entrySet()) {
            Set<String> ignoredMethods = this.findIgnoredMethods(ignoredTests, testClazzFolder.getKey());
            this.getClazzLog(testClazzFolder.getKey(), testClazzFolder.getValue(), ignoredMethods);
        }
        return this.files;
    }

    private Set<String> findIgnoredMethods(TestSet ignoredTests, File testClazzFolder) {
        if (ignoredTests == null) {
            return Collections.emptySet();
        }
        for (Map.Entry ignoredTest : ignoredTests.entrySet()) {
            String clazzName = this.extractClazzNameFromTestClazzFolder(testClazzFolder);
            if (!((TestClazzCall)ignoredTest.getKey()).getClazz().equals(clazzName)) continue;
            return (Set)ignoredTest.getValue();
        }
        return Collections.emptySet();
    }

    private void getClazzLog(File testClazzFolder, String module, Set<String> ignoredMethods) {
        LOG.debug("Looking for method files in {}", (Object)testClazzFolder.getAbsolutePath());
        File[] methodFiles = testClazzFolder.listFiles();
        if (methodFiles != null) {
            String clazz = this.extractClazzNameFromTestClazzFolder(testClazzFolder);
            for (File methodFile : methodFiles) {
                LOG.debug("Looking for method log file in {}", (Object)methodFile.getAbsolutePath());
                if (methodFile.isDirectory()) continue;
                this.testClazzFolder = testClazzFolder;
                this.methodFile = methodFile;
                String method = methodFile.getName().substring(0, methodFile.getName().length() - ".txt".length());
                this.test = new TestMethodCall(clazz, method, module);
                boolean ignored = ignoredMethods.contains(method);
                LOG.debug("Found method log file in {}{}", (Object)methodFile.getAbsolutePath(), (Object)(ignored ? ", corresponding test was {} ignored/disabled" : ""));
                this.addMethodLog(ignored);
            }
        }
    }

    private String extractClazzNameFromTestClazzFolder(File testClazzFolder) {
        return testClazzFolder.getName().substring("log_".length());
    }

    private void addMethodLog(boolean ignored) {
        File clazzDir = this.visualizationFolders.getResultsFolders().getClazzDir(this.commit, (TestCase)this.test);
        File viewMethodDir = new File(clazzDir, this.test.getMethodWithParams());
        boolean foundAnyParameterized = false;
        foundAnyParameterized = !viewMethodDir.exists() ? this.addParameterizedMethodLogs(clazzDir, null, ignored) : this.addParameterizedMethodLogs(clazzDir, viewMethodDir, ignored);
        if (!foundAnyParameterized) {
            this.addRegularMethodLog(viewMethodDir, ignored);
        }
    }

    private boolean addParameterizedMethodLogs(File clazzDir, File viewMethodDir, boolean ignored) {
        boolean foundAnyParameterized = false;
        File[] potentialParameterFiles = clazzDir.listFiles();
        if (potentialParameterFiles != null) {
            for (File potentialParameterizedFile : potentialParameterFiles) {
                String fileName = potentialParameterizedFile.getName();
                if (!fileName.startsWith(this.test.getMethodWithParams() + "(")) continue;
                foundAnyParameterized = true;
                LOG.debug("Found parameterized trace file: {}", (Object)potentialParameterizedFile);
                if (this.methodFile.getName().contains("(")) {
                    String params = fileName.substring(this.test.getMethod().length() + 1, fileName.length() - 1);
                    this.test = new TestMethodCall(this.test.getClazz(), this.test.getMethod(), this.test.getModule(), params);
                    boolean runWasSuccessful = this.checkRunWasSuccessful(viewMethodDir);
                    this.addMethodLogData(runWasSuccessful, false, ignored);
                    continue;
                }
                this.test = new TestMethodCall(this.test.getClazz(), this.test.getMethod(), this.test.getModule());
                this.addMethodLogData(true, true, ignored);
            }
        }
        return foundAnyParameterized;
    }

    private void addRegularMethodLog(File viewMethodDir, boolean ignored) {
        boolean runWasSuccessful = this.checkRunWasSuccessful(viewMethodDir);
        this.addMethodLogData(runWasSuccessful, false, ignored);
    }

    private boolean checkRunWasSuccessful(File viewMethodDir) {
        File viewMethodFile = new File(viewMethodDir, TraceWriter.getShortCommit((String)this.commit) + ".txt");
        File viewMethodFileZip = new File(viewMethodDir, TraceWriter.getShortCommit((String)this.commit) + ".zip");
        return viewMethodFile.exists() || viewMethodFileZip.exists();
    }

    private void addMethodLogData(boolean runWasSuccessful, boolean isParameterizedWithoutIndex, boolean ignored) {
        File cleanFile = new File(this.testClazzFolder, "clean" + File.separator + this.methodFile.getName());
        RTSLogData data = new RTSLogData(this.commit, this.methodFile, cleanFile, runWasSuccessful, isParameterizedWithoutIndex, ignored);
        this.files.put(this.test, data);
        LOG.debug("Adding log: {}", (Object)this.test);
    }
}

