/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.logs.measurement;

import de.dagere.peass.ci.PeassProcessConfiguration;
import de.dagere.peass.ci.helper.IdHelper;
import de.dagere.peass.ci.logs.InternalLogAction;
import de.dagere.peass.ci.logs.LogFileReader;
import de.dagere.peass.ci.logs.LogFiles;
import de.dagere.peass.ci.logs.LogUtil;
import de.dagere.peass.ci.logs.measurement.LogAction;
import de.dagere.peass.ci.logs.measurement.LogOverviewAction;
import de.dagere.peass.config.FixedCommitConfig;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.dependency.analysis.data.TestCase;
import de.dagere.peass.dependency.analysis.testData.TestMethodCall;
import hudson.model.Action;
import hudson.model.Run;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MeasurementActionCreator {
    private static final Logger LOG = LogManager.getLogger(MeasurementActionCreator.class);
    private final LogFileReader reader;
    private final Run<?, ?> run;
    private final PeassProcessConfiguration processConfig;
    private final MeasurementConfig measurementConfig;
    private final Pattern pattern;

    public MeasurementActionCreator(LogFileReader reader, Run<?, ?> run, PeassProcessConfiguration processConfig) {
        this.reader = reader;
        this.run = run;
        this.processConfig = processConfig;
        this.measurementConfig = processConfig.getMeasurementConfig();
        this.pattern = processConfig.getPattern();
    }

    public void createMeasurementActions(Set<TestMethodCall> tests) throws IOException {
        this.createOverallLogAction();
        Map<TestCase, List<LogFiles>> logFiles = this.reader.readAllTestcases(tests);
        this.createLogActions(this.run, logFiles);
        FixedCommitConfig fixedCommitConfig = this.measurementConfig.getFixedCommitConfig();
        String shortCommit = fixedCommitConfig.getCommit().substring(0, 6);
        String shortCommitOld = fixedCommitConfig.getCommitOld().substring(0, 6);
        LogOverviewAction logOverviewAction = new LogOverviewAction(IdHelper.getId(), logFiles, shortCommit, shortCommitOld, this.measurementConfig.getVms(), this.measurementConfig.getExecutionConfig().isRedirectSubprocessOutputToFile());
        this.run.addAction((Action)logOverviewAction);
    }

    private void createOverallLogAction() {
        if (this.measurementConfig.getExecutionConfig().isRedirectSubprocessOutputToFile()) {
            String measureLog = this.reader.getMeasureLog();
            String maskedLog = LogUtil.mask(measureLog, this.pattern);
            this.run.addAction((Action)new InternalLogAction(IdHelper.getId(), "measurementLog", "Measurement Log", maskedLog));
        }
    }

    private void createLogActions(Run<?, ?> run, Map<TestCase, List<LogFiles>> logFiles) throws IOException {
        for (Map.Entry<TestCase, List<LogFiles>> entry : logFiles.entrySet()) {
            LOG.debug("Creating {} log actions for {}", (Object)entry.getValue().size(), (Object)entry.getKey());
            TestCase testcase = entry.getKey();
            int vmId = 0;
            for (LogFiles files : entry.getValue()) {
                String logData = this.processConfig.getLogText(files.getCurrent());
                run.addAction((Action)new LogAction(IdHelper.getId(), testcase, vmId, this.measurementConfig.getFixedCommitConfig().getCommit(), logData));
                String logDataOld = this.processConfig.getLogText(files.getPredecessor());
                run.addAction((Action)new LogAction(IdHelper.getId(), testcase, vmId, this.measurementConfig.getFixedCommitConfig().getCommitOld(), logDataOld));
                ++vmId;
            }
        }
    }
}

