/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.logs.rca;

import de.dagere.peass.ci.PeassProcessConfiguration;
import de.dagere.peass.ci.helper.IdHelper;
import de.dagere.peass.ci.logs.InternalLogAction;
import de.dagere.peass.ci.logs.LogFileReader;
import de.dagere.peass.ci.logs.LogFiles;
import de.dagere.peass.ci.logs.LogUtil;
import de.dagere.peass.ci.logs.rca.RCALevel;
import de.dagere.peass.ci.logs.rca.RCALogAction;
import de.dagere.peass.ci.logs.rca.RCALogOverviewAction;
import de.dagere.peass.config.FixedCommitConfig;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.dependency.analysis.data.TestCase;
import hudson.model.Action;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class RCAActionCreator {
    private final LogFileReader reader;
    private final Run<?, ?> run;
    private final PeassProcessConfiguration peassConfig;
    private final MeasurementConfig measurementConfig;
    private final Pattern pattern;

    public RCAActionCreator(LogFileReader reader, Run<?, ?> run, PeassProcessConfiguration peassConfig) {
        this.reader = reader;
        this.run = run;
        this.peassConfig = peassConfig;
        this.measurementConfig = peassConfig.getMeasurementConfig();
        this.pattern = peassConfig.getPattern();
    }

    public void createRCAActions() throws IOException {
        this.createOverallActionLog();
        Map<TestCase, List<RCALevel>> testLevelMap = this.createRCALogActions(this.reader);
        FixedCommitConfig fixedCommitConfig = this.measurementConfig.getFixedCommitConfig();
        RCALogOverviewAction rcaOverviewAction = new RCALogOverviewAction(IdHelper.getId(), testLevelMap, fixedCommitConfig.getCommit().substring(0, 6), fixedCommitConfig.getCommitOld().substring(0, 6), this.measurementConfig.getExecutionConfig().isRedirectSubprocessOutputToFile());
        this.run.addAction((Action)rcaOverviewAction);
    }

    private void createOverallActionLog() {
        if (this.measurementConfig.getExecutionConfig().isRedirectSubprocessOutputToFile()) {
            String rcaLog = this.reader.getRCALog();
            String maskedLog = LogUtil.mask(rcaLog, this.pattern);
            this.run.addAction((Action)new InternalLogAction(IdHelper.getId(), "rcaLog", "RCA Log", maskedLog));
        }
    }

    private Map<TestCase, List<RCALevel>> createRCALogActions(LogFileReader reader) throws IOException {
        Map<TestCase, List<RCALevel>> testLevelMap = reader.getRCATestcases();
        for (Map.Entry<TestCase, List<RCALevel>> testcase : testLevelMap.entrySet()) {
            int levelId = 0;
            for (RCALevel level : testcase.getValue()) {
                this.createLevelLogAction(testcase, levelId, level);
                ++levelId;
            }
        }
        return testLevelMap;
    }

    private void createLevelLogAction(Map.Entry<TestCase, List<RCALevel>> testcase, int levelId, RCALevel level) throws IOException {
        int vmId = 0;
        for (LogFiles files : level.getLogFiles()) {
            this.createVMLogActions(testcase, levelId, vmId, files);
            ++vmId;
        }
    }

    private void createVMLogActions(Map.Entry<TestCase, List<RCALevel>> testcase, int levelId, int vmId, LogFiles files) throws IOException {
        this.addLog(testcase, levelId, vmId, files.getCurrent(), this.measurementConfig.getFixedCommitConfig().getCommit());
        this.addLog(testcase, levelId, vmId, files.getPredecessor(), this.measurementConfig.getFixedCommitConfig().getCommitOld());
    }

    private void addLog(Map.Entry<TestCase, List<RCALevel>> testcase, int levelId, int vmId, File logFile, String commit) throws IOException {
        String logData = logFile.exists() ? this.peassConfig.getLogText(logFile) : "Log file could not be found";
        this.run.addAction((Action)new RCALogAction(IdHelper.getId(), testcase.getKey(), vmId, levelId, commit, logData));
    }
}

