/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.logs.rts;

import de.dagere.peass.ci.RTSResult;
import de.dagere.peass.ci.logs.rts.RTSLogSummary;

public class AggregatedRTSResult {
    private final RTSLogSummary logSummary;
    private final RTSResult result;
    private final boolean rtsAnyError;
    private final boolean rtsAllError;

    public AggregatedRTSResult(RTSLogSummary logSummary, RTSResult result) {
        this.logSummary = logSummary;
        this.result = result;
        boolean isContainsSuccess = false;
        if (logSummary != null) {
            isContainsSuccess = logSummary.isVersionContainsSuccess() || logSummary.isPredecessorContainsSuccess();
            this.rtsAnyError = logSummary.isErrorInCurrentVersionOccured() || logSummary.isErrorInPredecessorVersionOccured();
            this.rtsAllError = logSummary.isErrorInCurrentVersionOccured() && !isContainsSuccess;
        } else {
            this.rtsAnyError = true;
            this.rtsAllError = true;
        }
    }

    public RTSLogSummary getLogSummary() {
        return this.logSummary;
    }

    public RTSResult getResult() {
        return this.result;
    }

    public boolean isRtsAnyError() {
        return this.rtsAnyError;
    }

    public boolean isRtsAllError() {
        return this.rtsAllError;
    }
}

