/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.logs.rts;

import de.dagere.peass.ci.PeassProcessConfiguration;
import de.dagere.peass.ci.helper.IdHelper;
import de.dagere.peass.ci.logs.InternalLogAction;
import de.dagere.peass.ci.logs.LogUtil;
import de.dagere.peass.ci.logs.RTSLogFileReader;
import de.dagere.peass.ci.logs.rts.ProcessSuccessLogAction;
import de.dagere.peass.ci.logs.rts.RTSLogAction;
import de.dagere.peass.ci.logs.rts.RTSLogData;
import de.dagere.peass.ci.logs.rts.RTSLogOverviewAction;
import de.dagere.peass.ci.logs.rts.RTSLogSummary;
import de.dagere.peass.ci.process.RTSInfos;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.dependency.analysis.data.TestCase;
import de.dagere.peass.dependency.analysis.data.TestSet;
import de.dagere.peass.dependency.analysis.testData.TestMethodCall;
import hudson.model.Action;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RTSActionCreator {
    private static final Logger LOG = LogManager.getLogger(RTSActionCreator.class);
    private final RTSLogFileReader reader;
    private final Run<?, ?> run;
    private final PeassProcessConfiguration processConfig;
    private final MeasurementConfig measurementConfig;
    private final Map<String, Boolean> processSuccessRunSucceeded = new HashMap<String, Boolean>();
    private RTSLogSummary logSummary;
    private final Pattern pattern;

    public RTSActionCreator(RTSLogFileReader reader, Run<?, ?> run, PeassProcessConfiguration processConfig) {
        this.reader = reader;
        this.run = run;
        this.processConfig = processConfig;
        this.measurementConfig = processConfig.getMeasurementConfig();
        this.pattern = processConfig.getPattern();
    }

    public void createRTSActions(RTSInfos staticChanges) throws IOException {
        if (this.reader.isLogsExisting()) {
            this.createOverallLogAction();
        } else {
            LOG.info("No RTS Actions existing; not creating regression test selection actions.");
        }
        Map<String, File> processSuccessRuns = this.createProcessSuccessRunsActions();
        Map<TestMethodCall, RTSLogData> rtsVmRuns = this.createVersionRTSData(this.measurementConfig.getFixedCommitConfig().getCommit(), staticChanges.getIgnoredTestsCurrent());
        Map<TestMethodCall, RTSLogData> rtsVmRunsPredecessor = this.createVersionRTSData(this.measurementConfig.getFixedCommitConfig().getCommitOld(), staticChanges.getIgnoredTestsPredecessor());
        this.logSummary = RTSLogSummary.createLogSummary(rtsVmRuns, rtsVmRunsPredecessor);
        this.createOverviewAction(processSuccessRuns, rtsVmRuns, rtsVmRunsPredecessor, staticChanges);
    }

    private void createOverviewAction(Map<String, File> processSuccessRuns, Map<TestMethodCall, RTSLogData> rtsVmRuns, Map<TestMethodCall, RTSLogData> rtsVmRunsPredecessor, RTSInfos rtsInfos) {
        RTSLogOverviewAction overviewAction = new RTSLogOverviewAction(IdHelper.getId(), processSuccessRuns, rtsVmRuns, rtsVmRunsPredecessor, this.processSuccessRunSucceeded, this.measurementConfig.getFixedCommitConfig().getCommit(), this.measurementConfig.getFixedCommitConfig().getCommitOld(), this.measurementConfig.getExecutionConfig().isRedirectSubprocessOutputToFile());
        overviewAction.setStaticChanges(rtsInfos.isStaticChanges());
        overviewAction.setStaticallySelectedTests(rtsInfos.isStaticallySelectedTests());
        this.run.addAction((Action)overviewAction);
    }

    private void createOverallLogAction() {
        if (this.measurementConfig.getExecutionConfig().isRedirectSubprocessOutputToFile()) {
            String rtsLog = this.reader.getRTSLog();
            String maskedLog = LogUtil.mask(rtsLog, this.pattern);
            this.run.addAction((Action)new InternalLogAction(IdHelper.getId(), "rtsLog", "Regression Test Selection Log", maskedLog));
            String sourceReadingLog = this.reader.getSourceReadingLog();
            this.run.addAction((Action)new InternalLogAction(IdHelper.getId(), "sourceLog", "Source Reading Log", sourceReadingLog));
        }
    }

    private Map<String, File> createProcessSuccessRunsActions() throws IOException {
        Map<String, File> processSuccessRuns = this.reader.findProcessSuccessRuns();
        for (Map.Entry<String, File> processSuccessRun : processSuccessRuns.entrySet()) {
            String logData = this.processConfig.getLogText(processSuccessRun.getValue());
            this.processSuccessRunSucceeded.put(processSuccessRun.getKey(), this.reader.isVersionRunWasSuccess());
            ProcessSuccessLogAction processSuccessAction = new ProcessSuccessLogAction(IdHelper.getId(), "processSuccessRun_" + processSuccessRun.getKey(), logData, processSuccessRun.getKey());
            this.run.addAction((Action)processSuccessAction);
        }
        return processSuccessRuns;
    }

    private Map<TestMethodCall, RTSLogData> createVersionRTSData(String commit, TestSet ignoredTests) throws IOException {
        Map<TestMethodCall, RTSLogData> rtsVmRuns = this.reader.getRtsVmRuns(commit, ignoredTests);
        LOG.info("RTS Runs: {}", (Object)rtsVmRuns.size());
        for (Map.Entry<TestMethodCall, RTSLogData> rtsLogData : rtsVmRuns.entrySet()) {
            String methodLogData = this.getLogData(rtsLogData.getValue().getMethodFile());
            String cleanLogData = this.getLogData(rtsLogData.getValue().getCleanFile());
            RTSLogAction logAction = new RTSLogAction(IdHelper.getId(), rtsLogData.getValue().getVersion(), (TestCase)rtsLogData.getKey(), cleanLogData, methodLogData);
            this.run.addAction((Action)logAction);
        }
        return rtsVmRuns;
    }

    private String getLogData(File methodFile) throws IOException {
        String methodLogData = methodFile.exists() ? FileUtils.readFileToString((File)methodFile, (Charset)StandardCharsets.UTF_8) : "Log could not be loaded";
        return methodLogData;
    }

    public RTSLogSummary getLogSummary() {
        return this.logSummary;
    }
}

