/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.logs.rts;

import de.dagere.peass.ci.Messages;
import de.dagere.peass.ci.VisibleAction;
import de.dagere.peass.ci.logs.rts.RTSLogData;
import de.dagere.peass.dependency.analysis.data.TestCase;
import de.dagere.peass.dependency.analysis.testData.TestMethodCall;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class RTSLogOverviewAction
extends VisibleAction {
    private Map<String, File> processSuccessRuns;
    private Map<String, Boolean> processSuccessRunSucceeded;
    private boolean staticChanges;
    private boolean staticallySelectedTests;
    private Map<TestMethodCall, RTSLogData> vmRuns;
    private Map<TestMethodCall, RTSLogData> predecessorVmRuns;
    private final String version;
    private final String versionOld;
    private boolean redirectSubprocessOutputToFile;

    public RTSLogOverviewAction(int id, Map<String, File> processSuccessRuns, Map<TestMethodCall, RTSLogData> vmRuns, Map<TestMethodCall, RTSLogData> predecessorVmRuns, Map<String, Boolean> processSuccessRunSucceeded, String commit, String commitOld, boolean redirectSubprocessOutputToFile) {
        super(id);
        this.processSuccessRuns = processSuccessRuns;
        this.vmRuns = vmRuns;
        this.predecessorVmRuns = predecessorVmRuns;
        this.processSuccessRunSucceeded = processSuccessRunSucceeded;
        this.version = commit;
        this.versionOld = commitOld;
        this.redirectSubprocessOutputToFile = redirectSubprocessOutputToFile;
    }

    public Map<String, File> getProcessSuccessRuns() {
        return this.processSuccessRuns;
    }

    public Set<TestCase> getAllTests() {
        TreeSet<TestCase> allTests = new TreeSet<TestCase>();
        allTests.addAll(this.vmRuns.keySet());
        allTests.addAll(this.predecessorVmRuns.keySet());
        return allTests;
    }

    public Map<TestMethodCall, RTSLogData> getVmRuns() {
        return this.vmRuns;
    }

    public Map<TestMethodCall, RTSLogData> getPredecessorVmRuns() {
        return this.predecessorVmRuns;
    }

    public Map<String, Boolean> getProcessSuccessRunSucceeded() {
        return this.processSuccessRunSucceeded;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVersionOld() {
        return this.versionOld;
    }

    public boolean isStaticChanges() {
        return this.staticChanges;
    }

    public void setStaticChanges(boolean staticChanges) {
        this.staticChanges = staticChanges;
    }

    public boolean isStaticallySelectedTests() {
        return this.staticallySelectedTests;
    }

    public void setStaticallySelectedTests(boolean staticallySelectedTests) {
        this.staticallySelectedTests = staticallySelectedTests;
    }

    public boolean isRedirectSubprocessOutputToFile() {
        return this.redirectSubprocessOutputToFile;
    }

    public String getIconFileName() {
        return "notepad.png";
    }

    public String getDisplayName() {
        return Messages.RTSLogOverviewAction_DisplayName();
    }

    public String getUrlName() {
        return "rtsLogOverview_" + this.id;
    }
}

