/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.logs.rts;

import de.dagere.peass.ci.logs.rts.RTSLogData;
import de.dagere.peass.dependency.analysis.testData.TestMethodCall;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RTSLogSummary {
    private static final Logger LOG = LogManager.getLogger(RTSLogSummary.class);
    private final boolean errorInCurrentVersionOccured;
    private final boolean errorInPredecessorVersionOccured;
    private final boolean versionContainsSuccess;
    private final boolean predecessorContainsSuccess;
    private final boolean versionContainsParametrizedwhithoutIndex;
    private final boolean predecessorContainsParametrizedwhithoutIndex;

    public static RTSLogSummary createLogSummary(Map<TestMethodCall, RTSLogData> rtsVmRuns, Map<TestMethodCall, RTSLogData> rtsVmRunsPredecessor) {
        boolean versionContainsFailure = rtsVmRuns.values().stream().anyMatch(log -> !log.isSuccess() && !log.isIgnored());
        boolean predecessorContainsFailure = rtsVmRunsPredecessor.values().stream().anyMatch(log -> !log.isSuccess() && !log.isIgnored());
        boolean versionContainsSuccess = rtsVmRuns.values().stream().anyMatch(log -> log.isSuccess());
        boolean predecessorContainsSuccess = rtsVmRunsPredecessor.values().stream().anyMatch(log -> log.isSuccess());
        boolean versionContainsParametrizedwhithoutIndex = rtsVmRuns.values().stream().anyMatch(log -> log.isParameterizedWithoutIndex());
        boolean predecessorContainsParametrizedwhithoutIndex = rtsVmRunsPredecessor.values().stream().anyMatch(log -> log.isParameterizedWithoutIndex());
        LOG.debug("Errors in logs: current: {} predecessor: {}", (Object)versionContainsFailure, (Object)predecessorContainsFailure);
        RTSLogSummary logSummary = new RTSLogSummary(versionContainsFailure, predecessorContainsFailure, versionContainsSuccess, predecessorContainsSuccess, versionContainsParametrizedwhithoutIndex, predecessorContainsParametrizedwhithoutIndex);
        return logSummary;
    }

    public RTSLogSummary(boolean errorInCurrentVersionOccured, boolean errorInPredecessorVersionOccured, boolean versionContainsSuccess, boolean predecessorContainsSuccess, boolean versionContainsParametrizedwhithoutIndex, boolean predecessorContainsParametrizedwhithoutIndex) {
        this.errorInCurrentVersionOccured = errorInCurrentVersionOccured;
        this.errorInPredecessorVersionOccured = errorInPredecessorVersionOccured;
        this.versionContainsSuccess = versionContainsSuccess;
        this.predecessorContainsSuccess = predecessorContainsSuccess;
        this.versionContainsParametrizedwhithoutIndex = versionContainsParametrizedwhithoutIndex;
        this.predecessorContainsParametrizedwhithoutIndex = predecessorContainsParametrizedwhithoutIndex;
    }

    public boolean isErrorInCurrentVersionOccured() {
        return this.errorInCurrentVersionOccured;
    }

    public boolean isErrorInPredecessorVersionOccured() {
        return this.errorInPredecessorVersionOccured;
    }

    public boolean isVersionContainsSuccess() {
        return this.versionContainsSuccess;
    }

    public boolean isPredecessorContainsSuccess() {
        return this.predecessorContainsSuccess;
    }

    public boolean isVersionContainsParametrizedwhithoutIndex() {
        return this.versionContainsParametrizedwhithoutIndex;
    }

    public boolean isPredecessorContainsParametrizedwhithoutIndex() {
        return this.predecessorContainsParametrizedwhithoutIndex;
    }
}

