/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.peassOverview;

import de.dagere.peass.ci.helper.IdHelper;
import de.dagere.peass.ci.peassOverview.PeassOverviewAction;
import de.dagere.peass.ci.peassOverview.Project;
import de.dagere.peass.ci.peassOverview.ProjectData;
import de.dagere.peass.ci.peassOverview.ProjectDataCreator;
import de.dagere.peass.ci.rca.RCAMapping;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class PeassOverviewBuilder
extends Builder
implements SimpleBuildStep,
Serializable {
    private static final long serialVersionUID = 8464953102259678145L;
    public static final String LAST_DAY = "LAST_DAY";
    public static final String LAST_WEEK = "LAST_WEEK";
    public static final String LAST_MONTH = "LAST_MONTH";
    public static final String ALL = "ALL";
    private List<Project> projects;
    private String timespan = "LAST_DAY";
    private String changeClassifications = "TODO;function;optimization;testchange;versionupdate;tooHighDeviation";
    private String unmeasuredClassifications = "TODO;remoteServerCall;noDataCleanup";

    @DataBoundConstructor
    public PeassOverviewBuilder() {
    }

    public void perform(Run<?, ?> run, FilePath workspace, EnvVars env, Launcher launcher, TaskListener listener) throws IOException {
        listener.getLogger().println("Generating Peass Overview");
        ProjectDataCreator creator = new ProjectDataCreator(this.projects, this.timespan);
        Map<String, ProjectData> projectData = creator.generateAllProjectData(run, listener);
        Map<String, RCAMapping> rcaMapping = creator.getRCAMappings(run);
        File localWorkspace = new File(run.getRootDir(), ".." + File.separator + ".." + File.separator + "peass-data").getCanonicalFile();
        PeassOverviewAction action = new PeassOverviewAction(IdHelper.getId(), projectData, rcaMapping, this.changeClassifications, this.unmeasuredClassifications, localWorkspace.getAbsolutePath());
        run.addAction((Action)action);
    }

    public List<Project> getProjects() {
        return this.projects;
    }

    @DataBoundSetter
    public void setProjects(List<Project> projects) {
        this.projects = projects;
    }

    public String getTimespan() {
        return this.timespan;
    }

    @DataBoundSetter
    public void setTimespan(String timespan) {
        this.timespan = timespan;
    }

    public String getChangeClassifications() {
        return this.changeClassifications;
    }

    @DataBoundSetter
    public void setChangeClassifications(String changeClassifications) {
        this.changeClassifications = changeClassifications;
    }

    public String getUnmeasuredClassifications() {
        return this.unmeasuredClassifications;
    }

    @DataBoundSetter
    public void setUnmeasuredClassifications(String unmeasuredClassifications) {
        this.unmeasuredClassifications = unmeasuredClassifications;
    }

    @Symbol(value={"peassOverview"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Peass Overview";
        }
    }
}

