/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.peassOverview;

import de.dagere.peass.analysis.changes.Change;
import de.dagere.peass.analysis.changes.Changes;
import de.dagere.peass.analysis.changes.ProjectChanges;
import de.dagere.peass.analysis.measurement.ProjectStatistics;
import de.dagere.peass.ci.peassOverview.ChangeLine;
import de.dagere.peass.dependency.analysis.data.ChangedEntity;
import de.dagere.peass.dependency.analysis.data.TestCase;
import de.dagere.peass.dependency.analysis.data.TestSet;
import de.dagere.peass.dependency.analysis.testData.TestMethodCall;
import de.dagere.peass.dependency.persistence.CommitStaticSelection;
import de.dagere.peass.dependency.persistence.StaticTestSelection;
import de.dagere.peass.measurement.statistics.data.TestcaseStatistic;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ProjectData {
    private final StaticTestSelection selection;
    private final ProjectChanges changes;
    private final ProjectStatistics statistics;
    private final boolean containsError;

    public ProjectData(StaticTestSelection selection, ProjectChanges changes, ProjectStatistics statistics, boolean containsError) {
        this.selection = selection;
        this.changes = changes;
        this.statistics = statistics;
        this.containsError = containsError;
    }

    public StaticTestSelection getSelection() {
        return this.selection;
    }

    public ProjectChanges getChanges() {
        return this.changes;
    }

    public ProjectStatistics getStatistics() {
        return this.statistics;
    }

    public boolean isContainsError() {
        return this.containsError;
    }

    public List<ChangeLine> getChangeLines() {
        LinkedList<ChangeLine> result = new LinkedList<ChangeLine>();
        if (this.selection != null) {
            for (Map.Entry commitEntry : this.selection.getCommits().entrySet()) {
                String commit = (String)commitEntry.getKey();
                CommitStaticSelection commitStaticSelection = (CommitStaticSelection)commitEntry.getValue();
                if (commitStaticSelection == null) continue;
                this.addCommitData(result, commit, commitStaticSelection);
            }
        }
        return result;
    }

    private void addCommitData(List<ChangeLine> result, String commit, CommitStaticSelection commitStaticSelection) {
        Map changedClazzes = commitStaticSelection.getChangedClazzes();
        LinkedHashMap<TestMethodCall, Set<String>> oneTestCausingChanges = new LinkedHashMap<TestMethodCall, Set<String>>();
        LinkedList<String> changesWithNoTest = new LinkedList<String>();
        this.fillOneOrLessTests(changedClazzes, oneTestCausingChanges, changesWithNoTest);
        this.addOneTestCausingChanges(result, commit, oneTestCausingChanges);
        this.addNoneTestCausingChanges(result, commit, changesWithNoTest);
    }

    private void fillOneOrLessTests(Map<ChangedEntity, TestSet> changedClazzes, Map<TestMethodCall, Set<String>> oneTestCausingChanges, List<String> changesWithNoTest) {
        for (Map.Entry<ChangedEntity, TestSet> entry : changedClazzes.entrySet()) {
            String changedEntity = entry.getKey().toString();
            if (entry.getValue().getTestMethods().size() > 0) {
                for (TestMethodCall test : entry.getValue().getTestMethods()) {
                    if (!oneTestCausingChanges.containsKey(test)) {
                        oneTestCausingChanges.put(test, new TreeSet());
                    }
                    oneTestCausingChanges.get(test).add(changedEntity);
                }
                continue;
            }
            if (entry.getValue().getTestMethods().size() == 1) {
                TestMethodCall test = (TestMethodCall)entry.getValue().getTestMethods().iterator().next();
                if (!oneTestCausingChanges.containsKey(test)) {
                    oneTestCausingChanges.put(test, new TreeSet());
                }
                oneTestCausingChanges.get(test).add(changedEntity);
                continue;
            }
            changesWithNoTest.add(changedEntity);
        }
    }

    private void addNoneTestCausingChanges(List<ChangeLine> result, String commit, List<String> changesWithNoTest) {
        if (changesWithNoTest.size() > 0) {
            ChangeLine line = new ChangeLine(commit, changesWithNoTest, "none", Double.NaN);
            result.add(line);
        }
    }

    private void addOneTestCausingChanges(List<ChangeLine> result, String commit, Map<TestMethodCall, Set<String>> oneTestCausingChanges) {
        for (Map.Entry<TestMethodCall, Set<String>> oneTestEntry : oneTestCausingChanges.entrySet()) {
            TestMethodCall test = oneTestEntry.getKey();
            double changeValue = this.getChangeValue(commit, test);
            LinkedList<String> changesAsList = new LinkedList<String>();
            changesAsList.addAll((Collection)oneTestEntry.getValue());
            ChangeLine line = new ChangeLine(commit, changesAsList, test.toString(), changeValue);
            result.add(line);
        }
    }

    private double getChangeValue(String commit, TestMethodCall test) {
        TestcaseStatistic testcaseStatistic = this.getTestcaseStatistic(commit, (TestCase)test);
        Changes commitChanges = this.changes.getCommitChanges(commit);
        Change change = commitChanges.getChange(test);
        double changeValue = this.getPrintableChangeValue(testcaseStatistic, change);
        return changeValue;
    }

    private TestcaseStatistic getTestcaseStatistic(String commit, TestCase test) {
        Map commitStatistics = (Map)this.statistics.getStatistics().get(commit);
        TestcaseStatistic testcaseStatistic = commitStatistics != null ? (TestcaseStatistic)commitStatistics.get(test) : null;
        return testcaseStatistic;
    }

    private double getPrintableChangeValue(TestcaseStatistic testcaseStatistic, Change change) {
        double changeValue = change != null ? change.getChangePercent() : (testcaseStatistic != null ? 0.0 : Double.NaN);
        return changeValue;
    }
}

