/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.peassOverview;

import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.databind.DatabindException;
import de.dagere.peass.analysis.changes.ProjectChanges;
import de.dagere.peass.analysis.measurement.ProjectStatistics;
import de.dagere.peass.ci.peassOverview.PeassOverviewUtils;
import de.dagere.peass.ci.peassOverview.Project;
import de.dagere.peass.ci.peassOverview.ProjectData;
import de.dagere.peass.ci.rca.RCAMapping;
import de.dagere.peass.dependency.persistence.ExecutionData;
import de.dagere.peass.dependency.persistence.StaticTestSelection;
import de.dagere.peass.folders.ResultsFolders;
import de.dagere.peass.testtransformation.TestMethodHelper;
import de.dagere.peass.utils.Constants;
import de.dagere.peass.vcs.CommitList;
import de.dagere.peass.vcs.GitCommit;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class ProjectDataCreator {
    private static final Logger LOG = LogManager.getLogger(TestMethodHelper.class);
    private final List<Project> projects;
    private final String timespan;
    private static final DateTimeFormatter DATE_PARSER = ISODateTimeFormat.date();

    public ProjectDataCreator(List<Project> projects, String timespan) {
        this.projects = projects;
        this.timespan = timespan;
    }

    public Map<String, ProjectData> generateAllProjectData(Run<?, ?> run, TaskListener listener) {
        LinkedHashMap<String, ProjectData> projectData = new LinkedHashMap<String, ProjectData>();
        for (Project project : this.projects) {
            String projectPath = project.getProject();
            String projectName = project.getProjectName();
            try {
                File projectWorkspace = new File(run.getRootDir(), ".." + File.separator + ".." + File.separator + projectPath + File.separator + "peass-data");
                if (projectWorkspace.exists()) {
                    projectName = this.analyzeProject(run, listener, projectData, project, projectName, projectWorkspace);
                    continue;
                }
                listener.getLogger().println("Could not analyze " + projectPath + ": expected file " + projectWorkspace.getAbsolutePath() + " did not exist");
                projectData.put(projectName, new ProjectData(null, null, null, true));
            }
            catch (IOException e) {
                listener.getLogger().println("Could not analyze " + projectPath);
                LOG.error("Was not able to analyze project {}", (Object)projectName);
                e.printStackTrace();
                projectData.put(projectName, new ProjectData(null, null, null, true));
            }
        }
        return projectData;
    }

    public Map<String, RCAMapping> getRCAMappings(Run<?, ?> run) {
        LinkedHashMap<String, RCAMapping> result = new LinkedHashMap<String, RCAMapping>();
        for (Project project : this.projects) {
            String projectPath = project.getProject();
            String projectName = project.getProjectName();
            File projectWorkspace = new File(run.getRootDir(), ".." + File.separator + ".." + File.separator + projectPath + File.separator + "peass-data");
            File rcaMappingFile = new File(projectWorkspace, "rcaMapping.json");
            if (rcaMappingFile.exists()) {
                try {
                    RCAMapping mapping = (RCAMapping)Constants.OBJECTMAPPER.readValue(rcaMappingFile, RCAMapping.class);
                    result.put(projectName, mapping);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            System.out.println("RCA mapping file not existing: " + rcaMappingFile.getAbsolutePath());
        }
        System.out.println("Result: " + result);
        return result;
    }

    private String analyzeProject(Run<?, ?> run, TaskListener listener, Map<String, ProjectData> projectData, Project project, String projectName, File projectWorkspace) throws IOException {
        if (project.getProjectName().equals(".")) {
            projectName = projectWorkspace.getParentFile().getCanonicalFile().getName();
        }
        ProjectData currentProjectData = this.getProjectData(run, listener, projectWorkspace, projectName);
        projectData.put(projectName, currentProjectData);
        return projectName;
    }

    private ProjectData getProjectData(Run<?, ?> run, TaskListener listener, File projectWorkspace, String projectName) throws IOException {
        ResultsFolders resultsFolders = new ResultsFolders(projectWorkspace, projectName);
        List<String> includedCommits = this.findIncludedCommits(resultsFolders);
        StaticTestSelection selection = (StaticTestSelection)Constants.OBJECTMAPPER.readValue(resultsFolders.getStaticTestSelectionFile(), StaticTestSelection.class);
        this.removeNotIncludedCommits(includedCommits, selection);
        if (resultsFolders.getTraceTestSelectionFile().exists()) {
            ExecutionData data = (ExecutionData)Constants.OBJECTMAPPER.readValue(resultsFolders.getTraceTestSelectionFile(), ExecutionData.class);
            PeassOverviewUtils.removeNotTraceSelectedTests(selection, data);
        }
        ProjectChanges projectChanges = this.getChanges(listener, resultsFolders);
        ProjectStatistics statistics = this.getStatistics(listener, resultsFolders);
        ProjectData currentProjectData = new ProjectData(selection, projectChanges, statistics, false);
        return currentProjectData;
    }

    private ProjectChanges getChanges(TaskListener listener, ResultsFolders resultsFolders) throws IOException, StreamReadException, DatabindException {
        ProjectChanges projectChanges = new ProjectChanges();
        File changeFile = resultsFolders.getChangeFile();
        if (changeFile.exists()) {
            projectChanges = (ProjectChanges)Constants.OBJECTMAPPER.readValue(changeFile, ProjectChanges.class);
        } else {
            listener.getLogger().println(changeFile.getAbsolutePath() + " does not exist! If there are no Trace-based Selected Tests, that's ok.");
        }
        return projectChanges;
    }

    private ProjectStatistics getStatistics(TaskListener listener, ResultsFolders resultsFolders) throws IOException, StreamReadException, DatabindException {
        ProjectStatistics projectChanges = new ProjectStatistics();
        File statisticsFile = resultsFolders.getStatisticsFile();
        if (statisticsFile.exists()) {
            projectChanges = (ProjectStatistics)Constants.OBJECTMAPPER.readValue(statisticsFile, ProjectStatistics.class);
        } else {
            listener.getLogger().println(statisticsFile.getAbsolutePath() + " does not exist! If there are no Trace-based Selected Tests, that's ok.");
        }
        return projectChanges;
    }

    private void removeNotIncludedCommits(List<String> includedCommits, StaticTestSelection selection) {
        HashSet usedVersions = new HashSet(selection.getCommits().keySet());
        for (String version : usedVersions) {
            if (includedCommits.contains(version)) continue;
            selection.getCommits().remove(version);
        }
    }

    private List<String> findIncludedCommits(ResultsFolders resultsFolders) throws IOException, StreamReadException, DatabindException {
        DateTime currentDate = new DateTime().withTimeAtStartOfDay();
        DateTime yesterday = currentDate.minusDays(1).withTimeAtStartOfDay();
        DateTime oneWeekBefore = currentDate.minusDays(7).withTimeAtStartOfDay();
        DateTime oneMonthBefore = currentDate.minusDays(31).withTimeAtStartOfDay();
        LinkedList<String> includedCommits = new LinkedList<String>();
        CommitList commitMetadata = (CommitList)Constants.OBJECTMAPPER.readValue(resultsFolders.getCommitMetadataFile(), CommitList.class);
        for (GitCommit commit : commitMetadata.getCommits()) {
            DateTime commitDate = this.getCommitDate(commit);
            if (this.timespan.equals("LAST_DAY")) {
                if (!commitDate.isEqual((ReadableInstant)currentDate) && !commitDate.isEqual((ReadableInstant)yesterday)) continue;
                includedCommits.add(commit.getTag());
                continue;
            }
            if (this.timespan.equals("LAST_WEEK")) {
                if (!commitDate.isEqual((ReadableInstant)currentDate) && (!commitDate.isAfter((ReadableInstant)oneWeekBefore) || !commitDate.isBefore((ReadableInstant)currentDate))) continue;
                includedCommits.add(commit.getTag());
                continue;
            }
            if (this.timespan.equals("LAST_MONTH")) {
                if (!commitDate.isEqual((ReadableInstant)currentDate) && (!commitDate.isAfter((ReadableInstant)oneMonthBefore) || !commitDate.isBefore((ReadableInstant)currentDate))) continue;
                includedCommits.add(commit.getTag());
                continue;
            }
            if (!this.timespan.equals("ALL")) continue;
            includedCommits.add(commit.getTag());
        }
        LOG.debug("Commits: " + includedCommits);
        return includedCommits;
    }

    private DateTime getCommitDate(GitCommit commit) {
        String jtdate = commit.getDate();
        if (jtdate.length() > 0) {
            String onlyDay = jtdate.substring(0, jtdate.indexOf(32));
            DateTime commitDate = DATE_PARSER.parseDateTime(onlyDay);
            return commitDate;
        }
        return DateTime.now();
    }
}

