/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.peassOverview;

import de.dagere.peass.ci.peassOverview.ProjectData;
import de.dagere.peass.ci.peassOverview.classification.ClassifiedProject;
import de.dagere.peass.ci.peassOverview.classification.TestcaseClassification;
import de.dagere.peass.dependency.analysis.data.TestCase;
import de.dagere.peass.dependency.persistence.CommitStaticSelection;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ProjectOverviewStatistic {
    private int commitsWithSourceChange;
    private int testsWithSourceChange;
    private int commitsWithChange;
    private int testsWithChange;
    private int commitsWithUnmeasured;
    private int unmeasuredTests;
    private Map<String, Integer> categoryTestCount = new LinkedHashMap<String, Integer>();
    private Map<String, Integer> categoryCommitCount = new LinkedHashMap<String, Integer>();

    public int getCommitsWithSourceChange() {
        return this.commitsWithSourceChange;
    }

    public void setCommitsWithSourceChange(int commitsWithSourceChange) {
        this.commitsWithSourceChange = commitsWithSourceChange;
    }

    public int getTestsWithSourceChange() {
        return this.testsWithSourceChange;
    }

    public void setTestsWithSourceChange(int testsWithSourceChange) {
        this.testsWithSourceChange = testsWithSourceChange;
    }

    public int getCommitsWithChange() {
        return this.commitsWithChange;
    }

    public void setCommitsWithChange(int commitWithChange) {
        this.commitsWithChange = commitWithChange;
    }

    public int getTestsWithChange() {
        return this.testsWithChange;
    }

    public void setTestsWithChange(int testsWithChange) {
        this.testsWithChange = testsWithChange;
    }

    public int getCommitsWithUnmeasured() {
        return this.commitsWithUnmeasured;
    }

    public void setCommitsWithUnmeasured(int commitsWithUnmeasured) {
        this.commitsWithUnmeasured = commitsWithUnmeasured;
    }

    public int getUnmeasuredTests() {
        return this.unmeasuredTests;
    }

    public void setUnmeasuredTests(int unmeasuredTests) {
        this.unmeasuredTests = unmeasuredTests;
    }

    public Map<String, Integer> getCategoryTestCount() {
        return this.categoryTestCount;
    }

    public void setCategoryTestCount(Map<String, Integer> categoryTestCount) {
        this.categoryTestCount = categoryTestCount;
    }

    public Map<String, Integer> getCategoryCommitCount() {
        return this.categoryCommitCount;
    }

    public void setCategoryCommitCount(Map<String, Integer> categoryCommitCount) {
        this.categoryCommitCount = categoryCommitCount;
    }

    public void increaseCategoryTestCount(String category) {
        Integer count = this.categoryTestCount.get(category);
        count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
        this.categoryTestCount.put(category, count);
    }

    public void increaseCategoryCommitCount(String category) {
        Integer count = this.categoryCommitCount.get(category);
        count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
        this.categoryCommitCount.put(category, count);
    }

    public static ProjectOverviewStatistic getFromClassification(String projectName, ProjectData projectData, ClassifiedProject classificationData) {
        ProjectOverviewStatistic statistic = new ProjectOverviewStatistic();
        int commitCount = projectData.getStatistics().getStatistics().size();
        statistic.setCommitsWithSourceChange(commitCount);
        int tests = projectData.getStatistics().getTestCount();
        statistic.setTestsWithSourceChange(tests);
        statistic.setCommitsWithChange(projectData.getChanges().getCommitChanges().size());
        statistic.setTestsWithChange(projectData.getChanges().getChangeCount());
        LinkedHashSet<String> commits = new LinkedHashSet<String>();
        commits.addAll(classificationData.getChangeClassifications().keySet());
        commits.addAll(classificationData.getUnmeasuredClassifications().keySet());
        int commitsWithUnmeasuredTest = 0;
        for (String commit : commits) {
            HashSet<String> classificationsInThisCommit = new HashSet<String>();
            ProjectOverviewStatistic.addChangeClassifications(classificationData, statistic, commit, classificationsInThisCommit);
            ProjectOverviewStatistic.addUnmeasuredClassifications(classificationData, statistic, commit, classificationsInThisCommit);
            CommitStaticSelection commitSelection = (CommitStaticSelection)projectData.getSelection().getCommits().get(commit);
            if (commitSelection != null) {
                int unmeasured = statistic.getUnmeasuredTests();
                Map commitStatistic = (Map)projectData.getStatistics().getStatistics().get(commit);
                for (TestCase test : commitSelection.getTests().getTests()) {
                    if (commitStatistic == null) {
                        ++unmeasured;
                        continue;
                    }
                    if (commitStatistic.get(test) != null) continue;
                    ++unmeasured;
                }
                if (unmeasured > 0) {
                    ++commitsWithUnmeasuredTest;
                }
                statistic.setUnmeasuredTests(unmeasured);
            }
            for (String commitClassification : classificationsInThisCommit) {
                statistic.increaseCategoryCommitCount(commitClassification);
            }
        }
        statistic.setCommitsWithUnmeasured(commitsWithUnmeasuredTest);
        return statistic;
    }

    public static ProjectOverviewStatistic getSumStatistic(Collection<ProjectOverviewStatistic> statistics) {
        ProjectOverviewStatistic result = new ProjectOverviewStatistic();
        for (ProjectOverviewStatistic statistic : statistics) {
            result.setCommitsWithChange(result.getCommitsWithChange() + statistic.getCommitsWithChange());
            result.setCommitsWithSourceChange(result.getCommitsWithSourceChange() + statistic.getCommitsWithSourceChange());
            result.setTestsWithChange(result.getTestsWithChange() + statistic.getTestsWithChange());
            result.setTestsWithSourceChange(result.getTestsWithSourceChange() + statistic.getTestsWithSourceChange());
            result.setCommitsWithUnmeasured(result.getCommitsWithUnmeasured() + statistic.getCommitsWithUnmeasured());
            result.setUnmeasuredTests(result.getUnmeasuredTests() + statistic.getUnmeasuredTests());
            for (String category : statistic.getCategoryCommitCount().keySet()) {
                Integer categoryCommitCount = result.getCategoryCommitCount().get(category);
                if (categoryCommitCount == null) {
                    categoryCommitCount = 0;
                }
                categoryCommitCount = categoryCommitCount + statistic.getCategoryCommitCount().get(category);
                result.getCategoryCommitCount().put(category, categoryCommitCount);
                Integer categoryTestCount = result.getCategoryTestCount().get(category);
                if (categoryTestCount == null) {
                    categoryTestCount = 0;
                }
                categoryTestCount = categoryTestCount + statistic.getCategoryTestCount().get(category);
                result.getCategoryTestCount().put(category, categoryTestCount);
            }
        }
        return result;
    }

    private static void addUnmeasuredClassifications(ClassifiedProject classificationData, ProjectOverviewStatistic statistic, String commit, Set<String> classificationsInThisCommit) {
        TestcaseClassification unmeasuredClassification = classificationData.getUnmeasuredClassification(commit);
        if (unmeasuredClassification != null) {
            Map<String, String> unmeasuredClassificationMap = unmeasuredClassification.getClassifications();
            for (Map.Entry<String, String> testcaseUnmeasuredClassification : unmeasuredClassificationMap.entrySet()) {
                String chosenClassification = testcaseUnmeasuredClassification.getValue();
                statistic.increaseCategoryTestCount(chosenClassification);
                classificationsInThisCommit.add(chosenClassification);
            }
        }
    }

    private static void addChangeClassifications(ClassifiedProject classificationData, ProjectOverviewStatistic statistic, String commit, Set<String> classificationsInThisCommit) {
        TestcaseClassification measuredClassification = classificationData.getChangeClassifications().get(commit);
        if (measuredClassification != null) {
            Map<String, String> measuredClassificationMap = measuredClassification.getClassifications();
            for (Map.Entry<String, String> testcaseClassification : measuredClassificationMap.entrySet()) {
                String chosenClassification = testcaseClassification.getValue();
                statistic.increaseCategoryTestCount(chosenClassification);
                classificationsInThisCommit.add(chosenClassification);
            }
        }
    }
}

