/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.peassOverview.classification;

import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.databind.DatabindException;
import de.dagere.peass.ci.peassOverview.classification.Classifications;
import de.dagere.peass.ci.peassOverview.classification.ClassifiedProject;
import de.dagere.peass.ci.peassOverview.classification.TestcaseClassification;
import de.dagere.peass.utils.Constants;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PrintStatistics {
    public static void main(String[] args) throws StreamReadException, DatabindException, IOException {
        File classificationFile = new File(args[0]);
        Classifications classifications = (Classifications)Constants.OBJECTMAPPER.readValue(classificationFile, Classifications.class);
        Map<String, Integer> categoryCount = PrintStatistics.getCategoryCount(classifications);
        Map<String, Integer> unmeasuredCount = PrintStatistics.getUnmeasuredCount(classifications);
        System.out.println("Categories: " + categoryCount);
        System.out.println("Unmeasured: " + unmeasuredCount);
    }

    private static Map<String, Integer> getCategoryCount(Classifications classifications) {
        HashMap<String, Integer> categoryCount = new HashMap<String, Integer>();
        for (ClassifiedProject project : classifications.getProjects().values()) {
            for (TestcaseClassification classification : project.getChangeClassifications().values()) {
                PrintStatistics.incrementCategoryCount(categoryCount, classification);
            }
        }
        return categoryCount;
    }

    private static Map<String, Integer> getUnmeasuredCount(Classifications classifications) {
        HashMap<String, Integer> categoryCount = new HashMap<String, Integer>();
        for (ClassifiedProject project : classifications.getProjects().values()) {
            for (TestcaseClassification classification : project.getUnmeasuredClassifications().values()) {
                PrintStatistics.incrementCategoryCount(categoryCount, classification);
            }
        }
        return categoryCount;
    }

    private static void incrementCategoryCount(Map<String, Integer> categoryCount, TestcaseClassification classification) {
        for (String type : classification.getClassifications().values()) {
            Integer count = categoryCount.get(type);
            if (count == null) {
                count = 0;
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            categoryCount.put(type, count);
        }
    }
}

