/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.peassOverview.importer;

import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import de.dagere.kopeme.kopemedata.DatacollectorResult;
import de.dagere.kopeme.kopemedata.Kopemedata;
import de.dagere.kopeme.kopemedata.TestMethod;
import de.dagere.kopeme.kopemedata.VMResult;
import de.dagere.kopeme.kopemedata.VMResultChunk;
import de.dagere.peass.utils.Constants;
import de.dagere.peass.vcs.GitUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class CommitImporter {
    private final File fullPeassFolder;
    private final File workspaceFolder;
    private final File projectResultsFolder;
    private final String commit;
    private final String predecessor;
    private final String jenkinsProjectName;

    public CommitImporter(File fullPeassFolder, File workspaceFolder, File projectResultsFolder, String commit, String predecessor, String jenkinsProjectName) {
        this.fullPeassFolder = fullPeassFolder;
        this.workspaceFolder = workspaceFolder;
        this.projectResultsFolder = projectResultsFolder;
        this.commit = commit;
        this.predecessor = predecessor;
        this.jenkinsProjectName = jenkinsProjectName;
    }

    public void prepareData() throws IOException, StreamReadException, DatabindException, StreamWriteException {
        File fakeMeasurementFolder = new File(this.fullPeassFolder, "measurement_" + this.commit + "_" + this.predecessor);
        if (!fakeMeasurementFolder.mkdir() && !fakeMeasurementFolder.exists()) {
            throw new RuntimeException("Could not create " + fakeMeasurementFolder);
        }
        GitUtils.goToCommit((String)this.commit, (File)this.workspaceFolder);
        this.importRCAData();
        this.importMeasurementFolder(fakeMeasurementFolder);
    }

    private void importRCAData() throws IOException {
        this.touchRCALogfile();
        File jobCommitFolder = new File(this.fullPeassFolder, this.jenkinsProjectName + "_peass/rca/treeMeasurementResults/" + this.commit);
        if (!jobCommitFolder.mkdirs() && !jobCommitFolder.exists()) {
            throw new RuntimeException("Could not create " + jobCommitFolder);
        }
        File rcaContentFolder = new File(this.projectResultsFolder, "rca-results");
        File rcaCommitFolder = new File(rcaContentFolder, "treeMeasurementResults/" + this.commit);
        if (rcaCommitFolder.exists()) {
            this.importRCACommitFolder(jobCommitFolder, rcaCommitFolder);
        } else {
            File[] rcaFolders = rcaContentFolder.listFiles();
            if (rcaFolders != null) {
                for (File folderCandidate : rcaFolders) {
                    File treeMeasurementResultCandidate;
                    if (!folderCandidate.isDirectory() || !(treeMeasurementResultCandidate = new File(folderCandidate, "treeMeasurementResults/" + this.commit)).exists()) continue;
                    this.importRCACommitFolder(jobCommitFolder, treeMeasurementResultCandidate);
                }
            }
        }
    }

    private void touchRCALogfile() throws IOException {
        File parentFile = new File(this.fullPeassFolder, "rcaLogs");
        System.out.println("RCA log folder creation: " + parentFile.mkdirs());
        File rcaLogFile = new File(parentFile, this.commit + "_" + this.predecessor + ".txt");
        FileUtils.touch((File)rcaLogFile);
        System.out.println("Created: " + rcaLogFile);
    }

    private void importRCACommitFolder(File jobCommitFolder, File rcaCommitFolder) throws IOException {
        File[] clazzFolders = rcaCommitFolder.listFiles();
        if (clazzFolders != null) {
            for (File clazzFolder : clazzFolders) {
                File jobClazzFolder = new File(jobCommitFolder, clazzFolder.getName());
                FileUtils.copyDirectory((File)clazzFolder, (File)jobClazzFolder);
            }
        }
    }

    private void importMeasurementFolder(File fakeMeasurementFolder) throws IOException, StreamReadException, DatabindException, StreamWriteException {
        File measurementResultFolder = new File(this.projectResultsFolder, "measurement-results");
        File measurementsFullFolder = new File(measurementResultFolder, "measurementsFull");
        if (measurementsFullFolder.exists()) {
            this.copyCommitData(this.commit, this.predecessor, fakeMeasurementFolder, measurementsFullFolder);
        } else {
            File[] chunkFolders = measurementResultFolder.listFiles((FilenameFilter)new WildcardFileFilter("chunk*"));
            if (chunkFolders != null) {
                for (File chunkFolder : chunkFolders) {
                    File chunkMeasurementsFullFolder = new File(chunkFolder, "measurementsFull");
                    this.copyCommitData(this.commit, this.predecessor, fakeMeasurementFolder, chunkMeasurementsFullFolder);
                }
            }
        }
    }

    private void copyCommitData(String commit, String predecessor, File fakeMeasurementFolder, File measurementsFullFolder) throws IOException, StreamReadException, DatabindException, StreamWriteException {
        File[] jsonFiles = measurementsFullFolder.listFiles();
        if (jsonFiles != null) {
            for (File jsonFile : jsonFiles) {
                if (!jsonFile.getName().endsWith(".json")) continue;
                Kopemedata data = (Kopemedata)Constants.OBJECTMAPPER.readValue(jsonFile, Kopemedata.class);
                for (VMResultChunk chunk : data.getChunks()) {
                    HashSet<String> commits = new HashSet<String>();
                    for (VMResult result : chunk.getResults()) {
                        commits.add(result.getCommit());
                    }
                    if (commits.size() != 2 || !commits.contains(commit) || !commits.contains(predecessor)) continue;
                    String clazzName = data.getClazz();
                    Kopemedata copiedData = new Kopemedata(clazzName);
                    copiedData.getMethods().add(new TestMethod(data.getFirstMethodResult().getMethod()));
                    copiedData.getFirstMethodResult().getDatacollectorResults().add(new DatacollectorResult(data.getFirstTimeDataCollector().getName()));
                    copiedData.getChunks().add(chunk);
                    File resultFile = new File(fakeMeasurementFolder, jsonFile.getName());
                    Constants.OBJECTMAPPER.writeValue(resultFile, (Object)copiedData);
                    String clazzWithoutModule = clazzName.substring(clazzName.indexOf("\u00a7") + 1);
                    File measurementsFolder = new File(measurementsFullFolder, "measurements");
                    if (measurementsFolder.exists()) {
                        File runFolder = new File(measurementsFolder, clazzWithoutModule + "/" + commit);
                        File commitFolder = new File(runFolder, commit);
                        File predecessorFolder = new File(runFolder, predecessor);
                        if (predecessorFolder.exists() && commitFolder.exists()) {
                            File runFolderCopied = new File(fakeMeasurementFolder, "measurements/" + clazzWithoutModule + "/" + commit);
                            System.out.println("Creating folder: " + runFolderCopied.mkdirs());
                            FileUtils.copyDirectory((File)commitFolder, (File)new File(runFolderCopied, commit));
                            FileUtils.copyDirectory((File)predecessorFolder, (File)new File(runFolderCopied, predecessor));
                            continue;
                        }
                        System.err.println("Folder " + predecessorFolder + " or " + commitFolder + " missing");
                        continue;
                    }
                    System.err.println("Folder " + measurementsFolder.getAbsolutePath() + " missing");
                }
            }
        }
    }
}

