/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.peassOverview.importer;

import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import de.dagere.peass.ci.peassOverview.importer.MeasurementMerger;
import de.dagere.peass.dependency.persistence.ExecutionData;
import de.dagere.peass.dependency.persistence.SelectedTests;
import de.dagere.peass.dependency.persistence.StaticTestSelection;
import de.dagere.peass.folders.ResultsFolders;
import de.dagere.peass.utils.Constants;
import de.dagere.peass.vcs.CommitList;
import de.dagere.peass.vcs.GitCommit;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

public class ImportStarter
implements Callable<Void> {
    private static final Logger LOG = LogManager.getLogger(ImportStarter.class);
    @CommandLine.Option(names={"-staticSelectionFile", "--staticSelectionFile"}, description={"Path to the staticSelectionFile"})
    protected File staticSelectionFile;
    @CommandLine.Option(names={"-executionFile", "--executionFile"}, description={"Path to the executionfile (may be trace based selection or coverage selection file)"}, required=true)
    protected File executionFile;
    @CommandLine.Option(names={"-changeFile", "--changeFile"}, description={"Path to the change file (normally changes.json)"}, required=true)
    protected File[] changeFile;
    @CommandLine.Option(names={"-fullPeassFolder", "--fullPeassFolder"}, description={"Path to the fullPeassFolder of the project (normally $project_fullPeass)"}, required=true)
    protected File fullPeassFolder;

    public static void main(String[] args) {
        CommandLine commandLine = new CommandLine((Object)new ImportStarter());
        commandLine.execute(args);
    }

    @Override
    public Void call() throws Exception {
        ResultsFolders folders;
        String projectFolderName;
        if (this.fullPeassFolder.getName().endsWith("_fullPeass")) {
            projectFolderName = this.fullPeassFolder.getName().substring(0, this.fullPeassFolder.getName().length() - "_fullPeass".length());
            folders = new ResultsFolders(this.fullPeassFolder, projectFolderName);
        } else if (this.fullPeassFolder.getName().equals("peass-data")) {
            projectFolderName = this.fullPeassFolder.getParentFile().getName();
            folders = new ResultsFolders(this.fullPeassFolder, projectFolderName);
        } else {
            throw new RuntimeException("Full peass folder needs to end with _fullPeass or be named peass-data!");
        }
        LOG.debug("Project name: {}", (Object)projectFolderName);
        SelectedTests selectedTests = this.importSelectionFiles(folders);
        this.writeCommitList(folders);
        MeasurementMerger measurementMerger = new MeasurementMerger(this.changeFile, selectedTests);
        measurementMerger.merge(folders);
        return null;
    }

    private SelectedTests importSelectionFiles(ResultsFolders folders) throws IOException {
        LOG.info("Copying {} to {}", (Object)this.executionFile, (Object)folders.getTraceTestSelectionFile());
        FileUtils.copyFile((File)this.executionFile, (File)folders.getTraceTestSelectionFile());
        if (this.staticSelectionFile == null) {
            String originalName = this.executionFile.getName().substring("traceTestSelection_".length(), this.executionFile.getName().length() - ".json".length());
            this.staticSelectionFile = new File(this.executionFile.getParentFile(), "staticTestSelection_" + originalName + ".json");
        }
        LOG.info("Copying {} to {}", (Object)this.staticSelectionFile, (Object)folders.getStaticTestSelectionFile());
        FileUtils.copyFile((File)this.staticSelectionFile, (File)folders.getStaticTestSelectionFile());
        SelectedTests tests = (SelectedTests)Constants.OBJECTMAPPER.readValue(this.staticSelectionFile, StaticTestSelection.class);
        return tests;
    }

    private void writeCommitList(ResultsFolders folders) throws IOException, StreamReadException, DatabindException, StreamWriteException {
        CommitList commits = new CommitList();
        ExecutionData executionData = (ExecutionData)Constants.OBJECTMAPPER.readValue(folders.getTraceTestSelectionFile(), ExecutionData.class);
        for (String commitName : executionData.getCommitNames()) {
            GitCommit gc = new GitCommit(commitName, "", "", "");
            commits.getCommits().add(gc);
        }
        Constants.OBJECTMAPPER.writeValue(folders.getCommitMetadataFile(), (Object)commits);
    }
}

