/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.peassOverview.importer;

import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import de.dagere.peass.analysis.changes.Change;
import de.dagere.peass.analysis.changes.Changes;
import de.dagere.peass.analysis.changes.ProjectChanges;
import de.dagere.peass.analysis.measurement.ProjectStatistics;
import de.dagere.peass.dependency.analysis.data.TestCase;
import de.dagere.peass.dependency.analysis.testData.TestMethodCall;
import de.dagere.peass.dependency.persistence.SelectedTests;
import de.dagere.peass.dependencyprocessors.CommitComparatorInstance;
import de.dagere.peass.folders.ResultsFolders;
import de.dagere.peass.measurement.statistics.data.TestcaseStatistic;
import de.dagere.peass.utils.Constants;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MeasurementMerger {
    private static final Logger LOG = LogManager.getLogger(MeasurementMerger.class);
    private File[] changeFile;
    private final SelectedTests selectedTests;

    @SuppressFBWarnings
    public MeasurementMerger(File[] changeFile, SelectedTests selectedTests) {
        this.changeFile = changeFile;
        this.selectedTests = selectedTests;
    }

    public void merge(ResultsFolders folders) throws IOException, StreamReadException, DatabindException, StreamWriteException {
        ProjectChanges changes = new ProjectChanges(new CommitComparatorInstance(this.selectedTests));
        ProjectStatistics statistics = new ProjectStatistics();
        for (File changeFileInstance : this.changeFile) {
            if (!changeFileInstance.exists()) {
                throw new RuntimeException("Import is only possible if changefile exists!");
            }
            this.readChangefile(changes, changeFileInstance);
            this.readStatisticsFile(statistics, changeFileInstance);
        }
        LOG.info("Writing to {}", (Object)folders.getChangeFile());
        Constants.OBJECTMAPPER.writeValue(folders.getChangeFile(), (Object)changes);
        LOG.info("Writing to {}", (Object)folders.getStatisticsFile());
        Constants.OBJECTMAPPER.writeValue(folders.getStatisticsFile(), (Object)statistics);
    }

    private void readStatisticsFile(ProjectStatistics statistics, File changeFileInstance) throws IOException, StreamReadException, DatabindException {
        File currentStatisticsFile = new File(changeFileInstance.getParentFile(), "statistics.json");
        ProjectStatistics currentStatistics = (ProjectStatistics)Constants.OBJECTMAPPER.readValue(currentStatisticsFile, ProjectStatistics.class);
        for (Map.Entry commitEntry : currentStatistics.getStatistics().entrySet()) {
            for (Map.Entry testEntry : ((Map)commitEntry.getValue()).entrySet()) {
                statistics.addMeasurement((String)commitEntry.getKey(), (TestMethodCall)testEntry.getKey(), (TestcaseStatistic)testEntry.getValue());
            }
        }
    }

    private void readChangefile(ProjectChanges changes, File changeFileInstance) throws IOException, StreamReadException, DatabindException {
        LOG.info("Reading from {}", (Object)changeFileInstance);
        ProjectChanges currentChanges = (ProjectChanges)Constants.OBJECTMAPPER.readValue(changeFileInstance, ProjectChanges.class);
        for (Map.Entry commitChanges : currentChanges.getCommitChanges().entrySet()) {
            String commit = (String)commitChanges.getKey();
            Map testcaseObjectChanges = ((Changes)commitChanges.getValue()).getTestcaseObjectChanges();
            for (Map.Entry testcase : testcaseObjectChanges.entrySet()) {
                for (Change change : (List)testcase.getValue()) {
                    changes.addChange((TestCase)testcase.getKey(), commit, change);
                }
            }
        }
    }
}

