/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.peassOverview.importer;

import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import de.dagere.peass.analysis.changes.Changes;
import de.dagere.peass.analysis.changes.ProjectChanges;
import de.dagere.peass.ci.peassOverview.importer.CommitImporter;
import de.dagere.peass.dependency.analysis.data.TestSet;
import de.dagere.peass.dependency.persistence.CommitStaticSelection;
import de.dagere.peass.dependency.persistence.ExecutionData;
import de.dagere.peass.dependency.persistence.StaticTestSelection;
import de.dagere.peass.utils.Constants;
import de.dagere.peass.vcs.CommitList;
import de.dagere.peass.vcs.GitCommit;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Base64;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OneJobImporter {
    private static final Logger LOG = LogManager.getLogger(OneJobImporter.class);
    private final StaticTestSelection staticSelection;
    private final ExecutionData executionData;
    private final ProjectChanges projectChanges;
    private final File workspaceFolder;
    private final File projectResultsFolder;
    private final File fullPeassFolder;
    private final File traceFolder;
    private final File fullPeassTraceFolder;
    private final String jenkinsProjectName;
    private final int timeout;
    private final String url;
    private final String authentication;
    private final CommitList commits = new CommitList();

    public OneJobImporter(File projectResultsFolder, File workspaceFolder, String url, String authentication, String projectName, int timeout) throws StreamReadException, DatabindException, IOException {
        this.projectResultsFolder = projectResultsFolder;
        this.workspaceFolder = workspaceFolder;
        this.url = url;
        this.authentication = authentication;
        this.timeout = timeout;
        this.jenkinsProjectName = workspaceFolder.getName();
        this.fullPeassFolder = new File(workspaceFolder.getParentFile(), workspaceFolder.getName() + "_fullPeass");
        File staticSelectionFile = new File(projectResultsFolder, "results/staticTestSelection_" + projectName + ".json");
        File executionFile = new File(projectResultsFolder, "results/traceTestSelection_" + projectName + ".json");
        this.traceFolder = new File(projectResultsFolder, "results/views_" + projectName);
        if (!this.traceFolder.exists()) {
            throw new RuntimeException("Folder that should contain traces " + this.traceFolder + " did not exist");
        }
        this.fullPeassTraceFolder = new File(this.fullPeassFolder, "views_" + this.jenkinsProjectName);
        if (!this.fullPeassFolder.mkdirs()) {
            LOG.debug("Folder already existing");
        }
        this.staticSelection = (StaticTestSelection)Constants.OBJECTMAPPER.readValue(staticSelectionFile, StaticTestSelection.class);
        this.executionData = (ExecutionData)Constants.OBJECTMAPPER.readValue(executionFile, ExecutionData.class);
        this.projectChanges = (ProjectChanges)Constants.OBJECTMAPPER.readValue(new File(projectResultsFolder, "measurement-results/changes.json"), ProjectChanges.class);
        File jenkinsPropertyFolder = new File(this.fullPeassFolder, "properties_" + this.jenkinsProjectName);
        File resultsPropertyFolder = new File(projectResultsFolder, "results/properties_" + projectName);
        FileUtils.copyDirectory((File)resultsPropertyFolder, (File)jenkinsPropertyFolder);
        for (String commitName : this.executionData.getCommitNames()) {
            GitCommit gc = new GitCommit(commitName, "", "", "");
            this.commits.getCommits().add(gc);
        }
        Constants.OBJECTMAPPER.writeValue(new File(this.fullPeassFolder, "commits.json"), (Object)this.commits);
    }

    public void startImport() throws StreamWriteException, DatabindException, IOException, InterruptedException {
        StaticTestSelection copiedStaticSelection = new StaticTestSelection();
        copiedStaticSelection.setInitialcommit(this.staticSelection.getInitialcommit());
        ExecutionData copiedSelection = new ExecutionData();
        LOG.info("Importing " + this.executionData.getCommits().size() + " commits");
        for (Map.Entry<String, TestSet> entry : this.executionData.getCommits().entrySet()) {
            String commit = (String)entry.getKey();
            if (commit.equals(this.staticSelection.getInitialcommit().getCommit())) continue;
            String predecessor = ((TestSet)entry.getValue()).getPredecessor();
            Changes changes = this.projectChanges.getCommitChanges(commit);
            LOG.debug("Importing {}, Changes: {}", (Object)commit, changes != null ? Integer.valueOf(changes.getTestcaseChanges().size()) : null);
            this.prepareRTS(copiedStaticSelection, copiedSelection, entry, commit);
            if (entry.getValue().getTestMethods().size() <= 0) continue;
            CommitImporter commitImporter = new CommitImporter(this.fullPeassFolder, this.workspaceFolder, this.projectResultsFolder, commit, predecessor, this.jenkinsProjectName);
            commitImporter.prepareData();
            this.triggerBuild();
            Thread.sleep(this.timeout * 1000);
            FileUtils.deleteDirectory((File)new File(this.fullPeassFolder, this.jenkinsProjectName + "_peass/rca/"));
        }
        this.triggerBuild();
    }

    private void prepareRTS(StaticTestSelection copiedStaticSelection, ExecutionData copiedSelection, Map.Entry<String, TestSet> commitSelection, String commit) throws IOException, StreamWriteException, DatabindException {
        copiedSelection.addCall(commit, commitSelection.getValue());
        CommitStaticSelection commitStaticSelection = (CommitStaticSelection)this.staticSelection.getCommits().get(commit);
        copiedStaticSelection.getCommits().put(commit, commitStaticSelection);
        Constants.OBJECTMAPPER.writeValue(new File(this.fullPeassFolder, "traceTestSelection_" + this.jenkinsProjectName + ".json"), (Object)copiedSelection);
        Constants.OBJECTMAPPER.writeValue(new File(this.fullPeassFolder, "staticTestSelection_" + this.jenkinsProjectName + ".json"), (Object)copiedStaticSelection);
        File commitTraceFolder = new File(this.traceFolder, "view_" + commit);
        File commitFullPeassTraceFolder = new File(this.fullPeassTraceFolder, "view_" + commit);
        if (!commitFullPeassTraceFolder.exists() && commitTraceFolder.exists()) {
            FileUtils.copyDirectory((File)commitTraceFolder, (File)commitFullPeassTraceFolder);
        }
    }

    private void triggerBuild() throws MalformedURLException, IOException, UnsupportedEncodingException {
        URL urlObject = new URL(this.url);
        URLConnection uc = urlObject.openConnection();
        if (this.authentication != null) {
            String userpass = this.authentication;
            String basicAuth = "Basic " + new String(Base64.getEncoder().encode(userpass.getBytes("UTF-8")), "UTF-8");
            uc.setRequestProperty("Authorization", basicAuth);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(uc.getInputStream(), "UTF-8"));){
            String line;
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
        }
    }
}

