/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.persistence;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.dagere.peass.analysis.measurement.ProjectStatistics;
import de.dagere.peass.ci.persistence.TestMeasurementValues;
import de.dagere.peass.dependency.analysis.testData.TestMethodCall;
import de.dagere.peass.measurement.statistics.data.TestcaseStatistic;
import java.util.LinkedHashMap;
import java.util.Map;

public class BuildMeasurementValues {
    private Map<String, TestMeasurementValues> values = new LinkedHashMap<String, TestMeasurementValues>();

    public Map<String, TestMeasurementValues> getValues() {
        return this.values;
    }

    public void setValues(Map<String, TestMeasurementValues> values) {
        this.values = values;
    }

    @JsonIgnore
    public void addMeasurement(ProjectStatistics currentVersionStatistics, int buildNumber) {
        for (Map.Entry version : currentVersionStatistics.getStatistics().entrySet()) {
            for (Map.Entry testcase : ((Map)version.getValue()).entrySet()) {
                String testcaseName = ((TestMethodCall)testcase.getKey()).toString();
                TestMeasurementValues testcasePersistedValues = this.values.get(testcaseName);
                if (testcasePersistedValues == null) {
                    testcasePersistedValues = new TestMeasurementValues();
                    this.values.put(testcaseName, testcasePersistedValues);
                }
                testcasePersistedValues.getStatistics().put(buildNumber, (TestcaseStatistic)testcase.getValue());
            }
        }
    }
}

