/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.persistence;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import de.dagere.peass.analysis.measurement.ProjectStatistics;
import de.dagere.peass.ci.persistence.BuildMeasurementValues;
import de.dagere.peass.dependency.analysis.testData.TestMethodCall;
import de.dagere.peass.measurement.statistics.data.TestcaseStatistic;
import de.dagere.peass.utils.Constants;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class TrendFileUtil {
    public static final String TREND_FILE_NAME = "trend.json";

    public static void persistTrend(Run<?, ?> run, File localWorkspace, ProjectStatistics statistics) throws IOException, JsonParseException, JsonMappingException, JsonGenerationException {
        File trendFile = new File(localWorkspace, TREND_FILE_NAME);
        BuildMeasurementValues values = TrendFileUtil.getValues(trendFile);
        if (statistics.getStatistics().size() > 0) {
            if (values.getValues().size() == 0) {
                TrendFileUtil.addFakePredecessorStatistics(run, statistics, values);
            }
            values.addMeasurement(statistics, run.getNumber());
            Constants.OBJECTMAPPER.writeValue(trendFile, (Object)values);
        }
    }

    private static void addFakePredecessorStatistics(Run<?, ?> run, ProjectStatistics statistics, BuildMeasurementValues values) {
        ProjectStatistics fakePredecessorStatistics = new ProjectStatistics();
        Map.Entry currentEntry = statistics.getStatistics().entrySet().iterator().next();
        String commit = (String)currentEntry.getKey();
        for (Map.Entry entry : ((Map)currentEntry.getValue()).entrySet()) {
            TestcaseStatistic predecessor = new TestcaseStatistic();
            predecessor.setCalls(((TestcaseStatistic)entry.getValue()).getCallsOld());
            predecessor.setMeanCurrent(((TestcaseStatistic)entry.getValue()).getMeanOld());
            predecessor.setDeviationCurrent(((TestcaseStatistic)entry.getValue()).getDeviationOld());
            predecessor.setVMs(((TestcaseStatistic)entry.getValue()).getVMs());
            fakePredecessorStatistics.addMeasurement(commit + "~1", (TestMethodCall)entry.getKey(), predecessor);
        }
        values.addMeasurement(fakePredecessorStatistics, run.getNumber() - 1);
    }

    public static BuildMeasurementValues readMeasurementValues(File localWorkspace) throws JsonParseException, JsonMappingException, IOException, InterruptedException {
        File trendFile = new File(localWorkspace, TREND_FILE_NAME);
        System.out.println(trendFile.getAbsolutePath() + " " + trendFile.exists());
        BuildMeasurementValues values = TrendFileUtil.getValues(trendFile);
        return values;
    }

    private static BuildMeasurementValues getValues(File trendFile) throws IOException, JsonParseException, JsonMappingException {
        BuildMeasurementValues values = trendFile.exists() ? (BuildMeasurementValues)Constants.OBJECTMAPPER.readValue(trendFile, BuildMeasurementValues.class) : new BuildMeasurementValues();
        return values;
    }
}

