/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.process;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import kieker.monitoring.core.signaturePattern.InvalidPatternException;
import kieker.monitoring.core.signaturePattern.PatternParser;

public class IncludeExcludeParser {
    public static LinkedHashSet<String> getStringSet(String raw) {
        LinkedHashSet<String> includeList = new LinkedHashSet<String>();
        if (raw != null && raw.trim().length() > 0) {
            String nonSpaceIncludes = raw.trim();
            for (String include : nonSpaceIncludes.split(";")) {
                if (include.length() <= 0) continue;
                try {
                    PatternParser.parseToPattern((String)include);
                }
                catch (InvalidPatternException e) {
                    throw new RuntimeException("Can not parse pattern " + include, e);
                }
                includeList.add(include);
            }
        }
        return includeList;
    }

    public static List<String> getStringList(String raw) {
        StringBuilder errorMessageBuilder = new StringBuilder();
        LinkedList<String> includeList = new LinkedList<String>();
        if (raw != null && raw.trim().length() > 0) {
            String nonSpaceIncludes = raw.replaceAll(" ", "");
            for (String include : nonSpaceIncludes.split(";")) {
                includeList.add(include);
                if (include.contains("#")) continue;
                errorMessageBuilder.append("Include ").append(include).append(" does not contain #; this will not match any method. ");
            }
        }
        if (errorMessageBuilder.length() > 0) {
            throw new RuntimeException("Please always add includes in the form package.Class#method, and if you want to include all methods package.Class#*.  The following includes contained problems: " + errorMessageBuilder);
        }
        return includeList;
    }

    public static List<String> getStringListSimple(String raw) {
        LinkedList<String> includeList = new LinkedList<String>();
        if (raw != null && raw.trim().length() > 0) {
            String nonSpaceIncludes = raw.replaceAll(" ", "");
            for (String include : nonSpaceIncludes.split(";")) {
                includeList.add(include);
            }
        }
        return includeList;
    }
}

