/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.process;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.JsonMappingException;
import de.dagere.peass.analysis.changes.Changes;
import de.dagere.peass.analysis.changes.ProjectChanges;
import de.dagere.peass.analysis.measurement.ProjectStatistics;
import de.dagere.peass.ci.ContinuousFolderUtil;
import de.dagere.peass.ci.MeasurementOverviewAction;
import de.dagere.peass.ci.PeassProcessConfiguration;
import de.dagere.peass.ci.RTSResult;
import de.dagere.peass.ci.helper.DefaultMeasurementVisualizer;
import de.dagere.peass.ci.helper.HistogramReader;
import de.dagere.peass.ci.helper.HistogramValues;
import de.dagere.peass.ci.helper.IdHelper;
import de.dagere.peass.ci.helper.VisualizationFolderManager;
import de.dagere.peass.ci.logs.LogActionCreator;
import de.dagere.peass.ci.logs.rts.AggregatedRTSResult;
import de.dagere.peass.ci.logs.rts.RTSLogSummary;
import de.dagere.peass.ci.persistence.TrendFileUtil;
import de.dagere.peass.ci.process.RTSInfos;
import de.dagere.peass.ci.rca.RCAVisualizer;
import de.dagere.peass.ci.remote.RCAResult;
import de.dagere.peass.ci.remote.RemoteMeasurer;
import de.dagere.peass.ci.remote.RemoteRCA;
import de.dagere.peass.ci.remote.RemoteRTS;
import de.dagere.peass.ci.rts.RTSVisualizationCreator;
import de.dagere.peass.dependency.analysis.testData.TestMethodCall;
import de.dagere.peass.folders.ResultsFolders;
import de.dagere.peass.measurement.rca.CauseSearcherConfig;
import de.dagere.peass.measurement.statistics.data.TestcaseStatistic;
import de.dagere.peass.utils.Constants;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.DirScanner;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocalPeassProcessManager {
    private static final Logger LOG = LogManager.getLogger(LocalPeassProcessManager.class);
    private final FilePath workspace;
    private final File localWorkspace;
    private final TaskListener listener;
    private final PeassProcessConfiguration peassConfig;
    private final ResultsFolders results;
    private final LogActionCreator logActionCreator;
    private final VisualizationFolderManager visualizationFolders;

    public LocalPeassProcessManager(PeassProcessConfiguration peassConfig, FilePath workspace, File localWorkspace, TaskListener listener, Run<?, ?> run) {
        this.peassConfig = peassConfig;
        this.workspace = workspace;
        this.localWorkspace = localWorkspace;
        this.listener = listener;
        String projectName = new File(workspace.getRemote()).getName();
        this.results = new ResultsFolders(localWorkspace, projectName);
        this.visualizationFolders = new VisualizationFolderManager(localWorkspace, projectName, run);
        this.logActionCreator = new LogActionCreator(peassConfig, run, this.visualizationFolders);
    }

    public AggregatedRTSResult rts() throws IOException, InterruptedException {
        RemoteRTS rts = new RemoteRTS(this.peassConfig, this.listener);
        RTSResult result = (RTSResult)this.workspace.act((FilePath.FileCallable)rts);
        this.copyFromRemote();
        if (result != null) {
            String commitOld = result.getCommitOld();
            this.listener.getLogger().println("Setting predecessor version, obtained by RTS: " + commitOld);
            this.peassConfig.getMeasurementConfig().getFixedCommitConfig().setCommitOld(commitOld);
        }
        if (this.peassConfig.isDisplayRTSLogs()) {
            return this.displayRTSLogs(result);
        }
        if (result != null && result.getTests() != null) {
            AggregatedRTSResult aggregatedRTSResult = new AggregatedRTSResult(null, result);
            return aggregatedRTSResult;
        }
        return null;
    }

    private AggregatedRTSResult displayRTSLogs(RTSResult result) throws StreamReadException, DatabindException, IOException {
        RTSInfos infos = RTSInfos.readInfosFromFolders(this.results, this.peassConfig);
        RTSLogSummary summary = this.logActionCreator.createRTSActions(infos);
        AggregatedRTSResult aggregatedRTSResult = new AggregatedRTSResult(summary, result);
        return aggregatedRTSResult;
    }

    public boolean measure(Set<TestMethodCall> tests) throws IOException, InterruptedException {
        RemoteMeasurer remotePerformer = new RemoteMeasurer(this.peassConfig, this.listener, tests);
        boolean worked = (Boolean)this.workspace.act((FilePath.FileCallable)remotePerformer);
        this.listener.getLogger().println("Measurement worked: " + worked);
        this.copyFromRemote();
        if (this.peassConfig.isDisplayLogs()) {
            this.logActionCreator.createMeasurementActions(tests);
        }
        return worked;
    }

    public boolean rca(ProjectChanges changes, CauseSearcherConfig causeSearcherConfig) throws IOException, InterruptedException, Exception {
        RemoteRCA remoteRCAExecutor = new RemoteRCA(this.peassConfig, causeSearcherConfig, changes, this.listener);
        RCAResult result = (RCAResult)this.workspace.act((FilePath.FileCallable)remoteRCAExecutor);
        this.copyFromRemote();
        if (result.getFailedTests().size() > 0) {
            return false;
        }
        return result.isSuccess();
    }

    public void copyFromRemote() throws IOException, InterruptedException {
        String remotePeassPath = ContinuousFolderUtil.getLocalFolder((File)new File(this.workspace.getRemote())).getPath();
        this.listener.getLogger().println(Arrays.toString(new RuntimeException().getStackTrace()));
        this.listener.getLogger().println("Remote Peass path: " + remotePeassPath);
        FilePath remotePeassFolder = new FilePath(this.workspace.getChannel(), remotePeassPath);
        DirScanner.Glob dirScanner = new DirScanner.Glob("**/*,**/.git/**", "", false);
        int count = remotePeassFolder.copyRecursiveTo((DirScanner)dirScanner, new FilePath(this.localWorkspace), "Copy including git folder");
        this.listener.getLogger().println("Copied " + count + " files from " + remotePeassFolder + " to " + this.localWorkspace.getAbsolutePath());
    }

    public void visualizeRTSResults(Run<?, ?> run, RTSLogSummary logSummary) throws IOException {
        RTSVisualizationCreator rtsVisualizationCreator = new RTSVisualizationCreator(this.results, this.peassConfig);
        rtsVisualizationCreator.visualize(run, logSummary);
    }

    public ProjectChanges visualizeMeasurementResults(Run<?, ?> run) throws IOException, JsonParseException, JsonMappingException, JsonGenerationException {
        File dataFolder = this.results.getVersionFullResultsFolder(this.peassConfig.getMeasurementConfig());
        HistogramReader histogramReader = new HistogramReader(this.peassConfig.getMeasurementConfig(), dataFolder);
        Map<String, HistogramValues> measurements = histogramReader.readMeasurements();
        ProjectChanges changes = this.getChanges();
        ProjectStatistics statistics = this.readStatistics();
        TrendFileUtil.persistTrend(run, this.localWorkspace, statistics);
        Map<String, TestcaseStatistic> noWarmupStatistics = this.createPureMeasurementVisualization(run, dataFolder, measurements);
        Changes versionChanges = changes.getCommitChanges(this.peassConfig.getMeasurementConfig().getFixedCommitConfig().getCommit());
        MeasurementOverviewAction action = new MeasurementOverviewAction(IdHelper.getId(), this.peassConfig.getMeasurementConfig(), versionChanges, statistics, noWarmupStatistics, measurements, histogramReader.getUpdatedConfigurations());
        run.addAction((Action)action);
        return changes;
    }

    public void visualizeRCAResults(Run<?, ?> run, ProjectChanges changes) throws Exception, IOException {
        RCAVisualizer rcaVisualizer = new RCAVisualizer(this.peassConfig, this.visualizationFolders, changes, run);
        rcaVisualizer.visualizeRCA();
        if (this.peassConfig.isDisplayRCALogs()) {
            this.logActionCreator.createRCAActions();
        }
    }

    private Map<String, TestcaseStatistic> createPureMeasurementVisualization(Run<?, ?> run, File dataFolder, Map<String, HistogramValues> measurements) {
        DefaultMeasurementVisualizer visualizer = new DefaultMeasurementVisualizer(dataFolder, this.peassConfig.getMeasurementConfig().getFixedCommitConfig().getCommit(), run, this.visualizationFolders, measurements.keySet());
        visualizer.visualizeMeasurements();
        Map<String, TestcaseStatistic> noWarmupStatistics = visualizer.getNoWarmupStatistics();
        return noWarmupStatistics;
    }

    private ProjectChanges getChanges() throws IOException, JsonParseException, JsonMappingException {
        File changeFile = this.results.getChangeFile();
        ProjectChanges changes = changeFile.exists() ? (ProjectChanges)Constants.OBJECTMAPPER.readValue(changeFile, ProjectChanges.class) : new ProjectChanges();
        return changes;
    }

    private ProjectStatistics readStatistics() throws IOException {
        File statisticsFile = this.results.getStatisticsFile();
        ProjectStatistics statistics = statisticsFile.exists() ? (ProjectStatistics)Constants.OBJECTMAPPER.readValue(statisticsFile, ProjectStatistics.class) : new ProjectStatistics();
        return statistics;
    }
}

