/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.process;

import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.databind.DatabindException;
import de.dagere.peass.ci.PeassProcessConfiguration;
import de.dagere.peass.dependency.analysis.data.TestSet;
import de.dagere.peass.dependency.persistence.CommitStaticSelection;
import de.dagere.peass.dependency.persistence.StaticTestSelection;
import de.dagere.peass.folders.ResultsFolders;
import de.dagere.peass.utils.Constants;
import java.io.File;
import java.io.IOException;

public class RTSInfos {
    private final boolean staticChanges;
    private final boolean staticallySelectedTests;
    private final TestSet ignoredTestsCurrent;
    private final TestSet ignoredTestsPredecessor;

    public RTSInfos(boolean staticChanges, boolean staticallySelectedTests, TestSet ignoredTestsCurrent, TestSet ignoredTestsPredecessor) {
        this.staticChanges = staticChanges;
        this.staticallySelectedTests = staticallySelectedTests;
        this.ignoredTestsCurrent = ignoredTestsCurrent;
        this.ignoredTestsPredecessor = ignoredTestsPredecessor;
    }

    public boolean isStaticChanges() {
        return this.staticChanges;
    }

    public boolean isStaticallySelectedTests() {
        return this.staticallySelectedTests;
    }

    public TestSet getIgnoredTestsCurrent() {
        return this.ignoredTestsCurrent;
    }

    public TestSet getIgnoredTestsPredecessor() {
        return this.ignoredTestsPredecessor;
    }

    public static RTSInfos readInfosFromFolders(ResultsFolders results, PeassProcessConfiguration peassConfig) throws StreamReadException, DatabindException, IOException {
        File staticTestSelectionFile = results.getStaticTestSelectionFile();
        if (staticTestSelectionFile.exists()) {
            CommitStaticSelection predecessor;
            boolean staticChanges = false;
            StaticTestSelection staticTestSelection = (StaticTestSelection)Constants.OBJECTMAPPER.readValue(staticTestSelectionFile, StaticTestSelection.class);
            CommitStaticSelection commitSelection = (CommitStaticSelection)staticTestSelection.getCommits().get(peassConfig.getMeasurementConfig().getFixedCommitConfig().getCommit());
            boolean hasStaticallySelectedTests = false;
            TestSet ignoredTestsCurrent = new TestSet();
            if (commitSelection != null) {
                TestSet tests;
                if (!commitSelection.getChangedClazzes().isEmpty()) {
                    staticChanges = true;
                }
                hasStaticallySelectedTests = !(tests = commitSelection.getTests()).getTests().isEmpty();
                ignoredTestsCurrent = commitSelection.getIgnoredAffectedTests();
            }
            TestSet ignoredTestsPredecessor = (predecessor = (CommitStaticSelection)staticTestSelection.getCommits().get(peassConfig.getMeasurementConfig().getFixedCommitConfig().getCommitOld())) != null ? predecessor.getIgnoredAffectedTests() : new TestSet();
            return new RTSInfos(staticChanges, hasStaticallySelectedTests, ignoredTestsCurrent, ignoredTestsPredecessor);
        }
        return new RTSInfos(false, false, new TestSet(), new TestSet());
    }
}

