/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.rca;

import de.dagere.peass.SearchCauseStarter;
import de.dagere.peass.analysis.changes.Change;
import de.dagere.peass.analysis.changes.Changes;
import de.dagere.peass.analysis.changes.ProjectChanges;
import de.dagere.peass.ci.NonIncludedTestRemover;
import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.config.FixedCommitConfig;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.dependency.analysis.data.TestCase;
import de.dagere.peass.dependency.analysis.testData.TestMethodCall;
import de.dagere.peass.dependencyprocessors.CommitComparatorInstance;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.folders.CauseSearchFolders;
import de.dagere.peass.measurement.rca.CauseSearcherConfig;
import de.dagere.peass.measurement.rca.data.CauseSearchData;
import de.dagere.peass.measurement.rca.kieker.BothTreeReader;
import de.dagere.peass.measurement.rca.searcher.CauseSearcher;
import de.dagere.peass.utils.Constants;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kieker.analysis.exception.AnalysisConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class RCAExecutor {
    private static final Logger LOG = LogManager.getLogger(RCAExecutor.class);
    private final MeasurementConfig config;
    private final File projectFolder;
    private final ProjectChanges changes;
    private final CauseSearcherConfig causeConfig;
    private final EnvironmentVariables env;
    private final CommitComparatorInstance comparator;
    private List<TestCase> failedTests = new LinkedList<TestCase>();

    public RCAExecutor(MeasurementConfig config, File workspaceFolder, ProjectChanges changes, CauseSearcherConfig causeConfig, EnvironmentVariables env) {
        this.config = config;
        this.projectFolder = workspaceFolder;
        this.changes = changes;
        this.causeConfig = causeConfig;
        this.env = env;
        this.comparator = new CommitComparatorInstance(Arrays.asList(config.getFixedCommitConfig().getCommitOld(), config.getFixedCommitConfig().getCommit()));
    }

    public void executeRCAs() throws IOException {
        Changes commitChanges = this.changes.getCommitChanges(this.config.getFixedCommitConfig().getCommit());
        boolean needsRCA = this.checkNeedsRCA(commitChanges);
        if (needsRCA) {
            LOG.info("At least one testcase was not successfully executed in the last build for the current version - executing RCA");
            MeasurementConfig currentConfig = new MeasurementConfig(this.config);
            currentConfig.setDirectlyMeasureKieker(false);
            for (Map.Entry testcases : commitChanges.getTestcaseChanges().entrySet()) {
                for (Change change : (List)testcases.getValue()) {
                    TestMethodCall testCase;
                    String testClazzName = (String)testcases.getKey();
                    if (testClazzName.contains("\u00a7")) {
                        int moduleSeparatorIndex = testClazzName.indexOf("\u00a7");
                        String module = testClazzName.substring(0, moduleSeparatorIndex);
                        String testclazz = testClazzName.substring(moduleSeparatorIndex + 1, testClazzName.length());
                        testCase = new TestMethodCall(testclazz, change.getMethod(), module, change.getParams());
                    } else {
                        testCase = new TestMethodCall(testClazzName, change.getMethod(), "", change.getParams());
                    }
                    boolean match = NonIncludedTestRemover.isTestIncluded((TestCase)testCase, (ExecutionConfig)this.config.getExecutionConfig());
                    if (match) {
                        try {
                            this.analyseChange(currentConfig, testCase);
                        }
                        catch (Exception e) {
                            this.failedTests.add((TestCase)testCase);
                            System.out.println("Was unable to analyze: " + change.getMethod());
                            e.printStackTrace();
                        }
                        continue;
                    }
                    LOG.info("Skipping not included test: {}", (Object)testCase);
                }
            }
        }
    }

    private boolean checkNeedsRCA(Changes commitChanges) throws IOException {
        boolean needsRCA = false;
        FixedCommitConfig commitConfig = this.config.getFixedCommitConfig();
        for (Map.Entry testcases : commitChanges.getTestcaseChanges().entrySet()) {
            for (Change change : (List)testcases.getValue()) {
                TestMethodCall testCase = TestMethodCall.createFromClassString((String)((String)testcases.getKey()), (String)change.getMethod());
                boolean match = NonIncludedTestRemover.isTestIncluded((TestCase)testCase, (ExecutionConfig)this.config.getExecutionConfig());
                if (!match) continue;
                File expectedResultFile = this.getExpectedRCAFile(testCase);
                if (!expectedResultFile.exists()) {
                    needsRCA = true;
                    LOG.debug("Did not find commit {} vs {} of testcase {}", (Object)commitConfig.getCommit(), (Object)commitConfig.getCommitOld(), (Object)testCase);
                    continue;
                }
                CauseSearchData lastData = (CauseSearchData)Constants.OBJECTMAPPER.readValue(expectedResultFile, CauseSearchData.class);
                String commitInData = lastData.getMeasurementConfig().getFixedCommitConfig().getCommit();
                String commitOldInData = lastData.getMeasurementConfig().getFixedCommitConfig().getCommitOld();
                if (commitInData.equals(commitConfig.getCommit()) && commitOldInData.equals(commitConfig.getCommitOld())) {
                    LOG.debug("Found commit {} vs {} of testcase {}", (Object)commitConfig.getCommit(), (Object)commitConfig.getCommitOld(), (Object)testCase);
                    LOG.debug("RCA-file: {}", (Object)expectedResultFile.getAbsolutePath());
                    continue;
                }
                LOG.debug("Did not find commit {} vs {} of testcase {}", (Object)commitConfig.getCommit(), (Object)commitConfig.getCommitOld(), (Object)testCase);
                needsRCA = true;
            }
        }
        return needsRCA;
    }

    private void analyseChange(MeasurementConfig currentConfig, TestMethodCall testCase) throws IOException, InterruptedException, XmlPullParserException, AnalysisConfigurationException {
        File expectedResultFile = this.getExpectedRCAFile(testCase);
        LOG.info("Testing {}", (Object)expectedResultFile);
        if (!expectedResultFile.exists()) {
            LOG.debug("Needs execution");
            this.executeRCA(currentConfig, testCase);
        }
    }

    private File getExpectedRCAFile(TestMethodCall testCase) {
        CauseSearchFolders folders = new CauseSearchFolders(this.projectFolder);
        File expectedResultFile = new File(folders.getRcaTreeFolder(this.config.getFixedCommitConfig().getCommit(), (TestCase)testCase), testCase.getMethodWithParams() + ".json");
        return expectedResultFile;
    }

    private void executeRCA(MeasurementConfig config, TestMethodCall testCase) throws IOException, InterruptedException {
        CauseSearcherConfig causeSearcherConfig = new CauseSearcherConfig(testCase, this.causeConfig);
        config.getKiekerConfig().setUseKieker(true);
        CauseSearchFolders alternateFolders = new CauseSearchFolders(this.projectFolder);
        BothTreeReader reader = new BothTreeReader(causeSearcherConfig, config, alternateFolders, this.env);
        CauseSearcher tester = SearchCauseStarter.getCauseSeacher((MeasurementConfig)config, (CauseSearcherConfig)causeSearcherConfig, (CauseSearchFolders)alternateFolders, (BothTreeReader)reader, (CommitComparatorInstance)this.comparator);
        tester.search();
    }

    public List<TestCase> getFailedTests() {
        return this.failedTests;
    }
}

