/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.rca;

import de.dagere.peass.analysis.changes.Change;
import de.dagere.peass.analysis.changes.Changes;
import de.dagere.peass.analysis.changes.ProjectChanges;
import de.dagere.peass.ci.PeassProcessConfiguration;
import de.dagere.peass.ci.RCAVisualizationAction;
import de.dagere.peass.ci.helper.IdHelper;
import de.dagere.peass.ci.helper.VisualizationFolderManager;
import de.dagere.peass.ci.rca.RCAMapping;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.dependency.analysis.testData.TestMethodCall;
import de.dagere.peass.utils.Constants;
import de.dagere.peass.visualization.VisualizeRCAStarter;
import hudson.model.Action;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RCAVisualizer {
    private static final Logger LOG = LogManager.getLogger(RCAVisualizer.class);
    private final PeassProcessConfiguration peassConfig;
    private final MeasurementConfig measurementConfig;
    private final VisualizationFolderManager visualizationFolders;
    private final ProjectChanges changes;
    private final Run<?, ?> run;
    private final RCAMapping mapping;

    public RCAVisualizer(PeassProcessConfiguration peassConfig, VisualizationFolderManager visualizationFolders, ProjectChanges changes, Run<?, ?> run) {
        this.peassConfig = peassConfig;
        this.measurementConfig = peassConfig.getMeasurementConfig();
        this.visualizationFolders = visualizationFolders;
        this.changes = changes;
        this.run = run;
        RCAMapping readMapping = new RCAMapping();
        try {
            File rcaMappingFile = visualizationFolders.getResultsFolders().getRCAMappingFile();
            if (rcaMappingFile.exists()) {
                readMapping = (RCAMapping)Constants.OBJECTMAPPER.readValue(rcaMappingFile, RCAMapping.class);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mapping = readMapping;
    }

    public void visualizeRCA() throws Exception {
        File visualizationFolder = this.visualizationFolders.getVisualizationFolder();
        VisualizeRCAStarter visualizer = this.preparePeassVisualizer(visualizationFolder);
        visualizer.call();
        File rcaResults = this.visualizationFolders.getRcaResultFolder();
        Changes versionChanges = this.changes.getCommitChanges(this.measurementConfig.getFixedCommitConfig().getCommit());
        File versionVisualizationFolder = new File(visualizationFolder, this.measurementConfig.getFixedCommitConfig().getCommit());
        this.createVisualizationActions(rcaResults, versionChanges, versionVisualizationFolder);
    }

    private VisualizeRCAStarter preparePeassVisualizer(File resultFolder) {
        VisualizeRCAStarter visualizer = new VisualizeRCAStarter();
        File dataFolder = this.visualizationFolders.getDataFolder();
        visualizer.setData(new File[]{dataFolder});
        File propertyFolder = this.visualizationFolders.getPropertyFolder();
        LOG.info("Setting property folder: " + propertyFolder);
        visualizer.setPropertyFolder(propertyFolder);
        visualizer.setResultFolder(resultFolder);
        return visualizer;
    }

    private void createVisualizationActions(File rcaResults, Changes versionChanges, File versionVisualizationFolder) throws IOException {
        String longestPrefix = RCAVisualizer.getLongestPrefix(versionChanges.getTestcaseChanges().keySet());
        LOG.info("Creating actions: " + versionChanges.getTestcaseChanges().size());
        for (Map.Entry<String, List<Change>> entry : versionChanges.getTestcaseChanges().entrySet()) {
            for (Change change : (List)entry.getValue()) {
                String fileName;
                String actionName;
                if (change.getParams() != null) {
                    actionName = (String)entry.getKey() + "_" + change.getMethod() + "(" + change.getParams() + ")";
                    fileName = (String)entry.getKey() + File.separator + change.getMethod() + "(" + change.getParams() + ")";
                } else {
                    actionName = (String)entry.getKey() + "_" + change.getMethod();
                    fileName = (String)entry.getKey() + File.separator + change.getMethod();
                }
                File jsFile = new File(versionVisualizationFolder, fileName + ".js");
                LOG.info("Trying to copy {} Exists: {}", (Object)jsFile.getAbsolutePath(), (Object)jsFile.exists());
                if (jsFile.exists()) {
                    this.createRCAAction(rcaResults, longestPrefix, entry, change, actionName, jsFile);
                    continue;
                }
                LOG.error("An error occured: " + jsFile.getAbsolutePath() + " not found");
            }
        }
    }

    public void createRCAAction(File rcaResults, String longestPrefix, Map.Entry<String, List<Change>> testcases, Change change, String name, File jsFile) throws IOException {
        String destName = testcases.getKey() + "_" + change.getMethod() + ".js";
        File rcaDestFile = new File(rcaResults, destName);
        FileUtils.copyFile((File)jsFile, (File)rcaDestFile);
        LOG.info("Adding: " + rcaDestFile + " " + name);
        String displayName = name.substring(longestPrefix.length());
        String content = this.peassConfig.getLogText(rcaDestFile);
        RCAVisualizationAction visualizationAction = new RCAVisualizationAction(IdHelper.getId(), displayName, content);
        this.run.addAction((Action)visualizationAction);
        TestMethodCall testMethodCall = TestMethodCall.createFromString((String)(testcases.getKey() + "#" + change.getMethodWithParams()));
        String url = this.run.getNumber() + "/" + visualizationAction.getUrlName();
        this.mapping.addMapping(this.measurementConfig.getFixedCommitConfig().getCommit(), testMethodCall, url);
        Constants.OBJECTMAPPER.writeValue(this.visualizationFolders.getResultsFolders().getRCAMappingFile(), (Object)this.mapping);
    }

    public static String getLongestPrefix(Set<String> tests) {
        String longestPrefix = tests.size() > 0 ? tests.iterator().next() : "";
        for (String clazz : tests) {
            String withoutClazzItself = clazz.substring(0, clazz.lastIndexOf(46) + 1);
            longestPrefix = StringUtils.getCommonPrefix((String[])new String[]{longestPrefix, withoutClazzItself});
        }
        return longestPrefix;
    }
}

