/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.remote;

import de.dagere.peass.ci.ContinuousExecutor;
import de.dagere.peass.ci.PeassProcessConfiguration;
import de.dagere.peass.ci.process.JenkinsLogRedirector;
import de.dagere.peass.ci.remote.SnapshotDependencyChecker;
import de.dagere.peass.dependency.analysis.testData.TestMethodCall;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jenkinsci.remoting.RoleChecker;

public class RemoteMeasurer
implements FilePath.FileCallable<Boolean> {
    private static final Logger LOG = LogManager.getLogger(RemoteMeasurer.class);
    private static final long serialVersionUID = 5145199366806250594L;
    private final PeassProcessConfiguration peassConfig;
    private final TaskListener listener;
    private final Set<TestMethodCall> tests;

    public RemoteMeasurer(PeassProcessConfiguration peassConfig, TaskListener listener, Set<TestMethodCall> tests) {
        this.peassConfig = peassConfig;
        this.listener = listener;
        this.tests = tests;
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
    }

    public Boolean invoke(File workspaceFolder, VirtualChannel channel) throws IOException, InterruptedException {
        JenkinsLogRedirector redirector = new JenkinsLogRedirector(this.listener);
        try {
            LOG.info("Starting remote invocation, VMs: " + this.peassConfig.getMeasurementConfig().getVms());
            if (this.peassConfig.isUpdateSnapshotDependencies()) {
                new SnapshotDependencyChecker(this.peassConfig.getMeasurementConfig(), workspaceFolder, this.listener.getLogger()).checkKopemeAndKieker();
            }
            ContinuousExecutor executor = new ContinuousExecutor(workspaceFolder, this.peassConfig.getMeasurementConfig(), this.peassConfig.getDependencyConfig(), this.peassConfig.getEnvVars());
            executor.measure(this.tests);
            Boolean bl = true;
            redirector.close();
            return bl;
        }
        catch (Throwable executor) {
            try {
                try {
                    redirector.close();
                }
                catch (Throwable throwable) {
                    executor.addSuppressed(throwable);
                }
                throw executor;
            }
            catch (Throwable e) {
                File test = new File(workspaceFolder, "error.txt");
                PrintStream writer = new PrintStream(test, "UTF-8");
                e.printStackTrace(writer);
                writer.flush();
                this.listener.getLogger().println("Exception thrown");
                e.printStackTrace(this.listener.getLogger());
                e.printStackTrace();
                return false;
            }
        }
    }
}

