/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.remote;

import de.dagere.peass.analysis.changes.ProjectChanges;
import de.dagere.peass.ci.ContinuousFolderUtil;
import de.dagere.peass.ci.PeassProcessConfiguration;
import de.dagere.peass.ci.logHandling.LogRedirector;
import de.dagere.peass.ci.rca.RCAExecutor;
import de.dagere.peass.ci.remote.RCAResult;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.dependency.analysis.data.TestCase;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.folders.ResultsFolders;
import de.dagere.peass.measurement.rca.CauseSearcherConfig;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import kieker.analysis.exception.AnalysisConfigurationException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jenkinsci.remoting.RoleChecker;

public class RemoteRCA
implements FilePath.FileCallable<RCAResult>,
Serializable {
    private static final long serialVersionUID = 5375409887559433077L;
    private final MeasurementConfig measurementConfig;
    private final CauseSearcherConfig causeConfig;
    private final ProjectChanges changes;
    private final EnvironmentVariables env;
    private final TaskListener listener;
    private final List<TestCase> failedTests = new LinkedList<TestCase>();

    public RemoteRCA(PeassProcessConfiguration peassConfig, CauseSearcherConfig causeConfig, ProjectChanges changes, TaskListener listener) {
        this.measurementConfig = peassConfig.getMeasurementConfig();
        this.causeConfig = causeConfig;
        this.changes = changes;
        this.listener = listener;
        this.env = peassConfig.getEnvVars();
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
    }

    public RCAResult invoke(File workspaceFolder, VirtualChannel channel) throws IOException, InterruptedException {
        File localFolder = ContinuousFolderUtil.getLocalFolder((File)workspaceFolder);
        ResultsFolders resultsFolder = new ResultsFolders(localFolder, workspaceFolder.getName());
        File logFile = resultsFolder.getRCALogFile(this.measurementConfig.getFixedCommitConfig().getCommit(), this.measurementConfig.getFixedCommitConfig().getCommitOld());
        if (logFile.exists()) {
            this.listener.getLogger().println("RCA log file " + logFile + " already exists - not rerunning RCA if it isn't deleted");
            return new RCAResult(true, new LinkedList<TestCase>());
        }
        if (this.measurementConfig.getExecutionConfig().isRedirectSubprocessOutputToFile()) {
            RCAResult rCAResult;
            this.listener.getLogger().println("Executing root cause analysis - Log goes to " + logFile.getAbsolutePath());
            LogRedirector director = new LogRedirector(logFile);
            try {
                this.executeRCA(workspaceFolder, localFolder, resultsFolder);
                rCAResult = new RCAResult(true, this.failedTests);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        director.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (AnalysisConfigurationException | XmlPullParserException e) {
                    File test = new File(workspaceFolder, "error.txt");
                    PrintStream writer = new PrintStream(test, "UTF-8");
                    e.printStackTrace(writer);
                    writer.flush();
                    this.listener.getLogger().println("Exception thrown");
                    e.printStackTrace(this.listener.getLogger());
                    e.printStackTrace();
                    return new RCAResult(false, this.failedTests);
                }
            }
            director.close();
            return rCAResult;
        }
        try {
            this.executeRCA(workspaceFolder, localFolder, resultsFolder);
            return new RCAResult(true, this.failedTests);
        }
        catch (IOException | InterruptedException | AnalysisConfigurationException | XmlPullParserException e) {
            e.printStackTrace();
            return new RCAResult(false, this.failedTests);
        }
    }

    private void executeRCA(File workspaceFolder, File localFolder, ResultsFolders resultsFolder) throws IOException, InterruptedException, XmlPullParserException, AnalysisConfigurationException {
        File projectFolderLocal = new File(localFolder, workspaceFolder.getName());
        File propertyFolder = resultsFolder.getPropertiesFolder();
        this.causeConfig.setPropertyFolder(propertyFolder);
        this.measurementConfig.getKiekerConfig().setOnlyOneCallRecording(false);
        this.listener.getLogger().println("Setting property folder: " + propertyFolder.getAbsolutePath());
        RCAExecutor rcaExecutor = new RCAExecutor(this.measurementConfig, projectFolderLocal, this.changes, this.causeConfig, this.env);
        rcaExecutor.executeRCAs();
        this.failedTests.addAll(rcaExecutor.getFailedTests());
    }

    public List<TestCase> getFailedTests() {
        return this.failedTests;
    }
}

