/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.remote;

import de.dagere.peass.ci.ContinuousExecutor;
import de.dagere.peass.ci.PeassProcessConfiguration;
import de.dagere.peass.ci.RTSResult;
import de.dagere.peass.ci.process.JenkinsLogRedirector;
import de.dagere.peass.ci.remote.SnapshotDependencyChecker;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jenkinsci.remoting.RoleChecker;

public class RemoteRTS
implements FilePath.FileCallable<RTSResult> {
    private static final long serialVersionUID = -837869375735980083L;
    private static final Logger LOG = LogManager.getLogger(RemoteRTS.class);
    private final PeassProcessConfiguration peassConfig;
    private final TaskListener listener;

    public RemoteRTS(PeassProcessConfiguration peassConfig, TaskListener listener) {
        this.peassConfig = peassConfig;
        this.listener = listener;
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
    }

    public RTSResult invoke(File workspaceFolder, VirtualChannel channel) throws IOException, InterruptedException {
        JenkinsLogRedirector redirector = new JenkinsLogRedirector(this.listener);
        LOG.info("Starting remote invocation, VMs: " + this.peassConfig.getMeasurementConfig().getVms());
        if (this.peassConfig.isUpdateSnapshotDependencies()) {
            new SnapshotDependencyChecker(this.peassConfig.getMeasurementConfig(), workspaceFolder, this.listener.getLogger()).checkKopemeAndKieker();
        }
        ContinuousExecutor executor = new ContinuousExecutor(workspaceFolder, this.peassConfig.getMeasurementConfig(), this.peassConfig.getDependencyConfig(), this.peassConfig.getEnvVars());
        String commitOld = executor.getCommitOld();
        try {
            RTSResult tests;
            RTSResult rTSResult = tests = executor.executeRTS();
            redirector.close();
            return rTSResult;
        }
        catch (Throwable e) {
            try {
                this.printErrorInformation(workspaceFolder, e);
                RTSResult rtsResult = new RTSResult(null, false);
                rtsResult.setCommitOld(commitOld);
                RTSResult rTSResult = rtsResult;
                redirector.close();
                return rTSResult;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        redirector.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable e2) {
                    this.printErrorInformation(workspaceFolder, e2);
                    return null;
                }
            }
        }
    }

    private void printErrorInformation(File workspaceFolder, Throwable e) throws FileNotFoundException, UnsupportedEncodingException {
        File test = new File(workspaceFolder, "error.txt");
        PrintStream writer = new PrintStream(test, "UTF-8");
        e.printStackTrace(writer);
        writer.flush();
        this.listener.getLogger().println("Exception thrown");
        e.printStackTrace(this.listener.getLogger());
        e.printStackTrace();
    }
}

