/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.remote;

import de.dagere.peass.ci.process.JenkinsLogRedirector;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.vcs.GitUtils;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import org.jenkinsci.remoting.RoleChecker;

public class RemoteVersionReader
implements FilePath.FileCallable<MeasurementConfig> {
    private static final long serialVersionUID = -1266048917282327539L;
    private final MeasurementConfig measurementConfig;
    private final TaskListener listener;

    public RemoteVersionReader(MeasurementConfig measurementConfig, TaskListener listener) {
        this.measurementConfig = measurementConfig;
        this.listener = listener;
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
    }

    public MeasurementConfig invoke(File workspaceFolder, VirtualChannel channel) throws IOException, InterruptedException {
        JenkinsLogRedirector redirector = new JenkinsLogRedirector(this.listener);
        try {
            String version = GitUtils.getName((String)"HEAD", (File)workspaceFolder);
            this.measurementConfig.getFixedCommitConfig().setCommit(version);
            if (this.measurementConfig.getFixedCommitConfig().getCommitOld() != null) {
                String versionOld = GitUtils.getName((String)this.measurementConfig.getFixedCommitConfig().getCommitOld(), (File)workspaceFolder);
                this.measurementConfig.getFixedCommitConfig().setCommitOld(versionOld);
            }
            MeasurementConfig measurementConfig = this.measurementConfig;
            redirector.close();
            return measurementConfig;
        }
        catch (Throwable throwable) {
            try {
                try {
                    redirector.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                e.printStackTrace(this.listener.getLogger());
                e.printStackTrace();
                return null;
            }
        }
    }
}

