/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.remote;

import de.dagere.peass.config.MeasurementConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SnapshotDependencyChecker {
    private static final Logger LOG = LogManager.getLogger(SnapshotDependencyChecker.class);
    private static final String seperator = File.separator;
    private final MeasurementConfig measurementConfig;
    private final File workspaceFolder;
    private final File kopemeFile;
    private final File kiekerFile;
    private final PrintStream output;

    public SnapshotDependencyChecker(MeasurementConfig measurementConfig, File workspaceFolder, PrintStream output) {
        this.measurementConfig = measurementConfig;
        this.workspaceFolder = workspaceFolder;
        this.output = output;
        File mavenRepo = SnapshotDependencyChecker.getRepository();
        File kopemeArtifactFolder = new File(mavenRepo, "de" + File.separator + "dagere" + File.separator + "kopeme" + File.separator + "kopeme-junit" + File.separator + "1.1.13");
        this.kopemeFile = new File(kopemeArtifactFolder, "kopeme-junit-1.1.13.jar");
        File kiekerArtifactFolder = new File(mavenRepo, "net" + File.separator + "kieker-monitoring" + File.separator + "kieker" + File.separator + "1.15.1");
        this.kiekerFile = new File(kiekerArtifactFolder, "kieker-1.15.1.jar");
    }

    public void checkKopemeAndKieker() throws InterruptedException, IOException {
        if ("1.15.1".contains("-SNAPSHOT") || "1.1.13".contains("-SNAPSHOT")) {
            boolean snapshotDependenciesExist = this.kopemeAndKiekerExist();
            LOG.info("Snapshot dependencies existing: {} Path: {}", (Object)snapshotDependenciesExist, (Object)this.kopemeFile.getAbsolutePath());
            if (!snapshotDependenciesExist) {
                this.cloneAndinstallPeass();
            }
            if (!this.kopemeAndKiekerExist()) {
                LOG.warn("Kopeme and/or Kieker dependencies could still not be found! Build will possibly fail!");
            }
        } else {
            LOG.info("Kieker version {} and KoPeMe version {} where no snapshots, so no snapshot dependency checking necessary", (Object)"1.15.1", (Object)"1.1.13");
        }
    }

    private static File getRepository() {
        String mavenRepo;
        String maven_home = System.getenv("HOME");
        LOG.debug("HOME: " + maven_home);
        if (maven_home != null) {
            mavenRepo = maven_home + seperator + ".m2" + seperator + "repository" + seperator;
        } else {
            String home = System.getProperty("user.home");
            mavenRepo = home + seperator + ".m2" + seperator + "repository" + seperator;
        }
        return new File(mavenRepo);
    }

    private boolean kopemeAndKiekerExist() {
        return this.kopemeFile.exists() && this.kiekerFile.exists();
    }

    private void cloneAndinstallPeass() throws InterruptedException, IOException {
        LOG.warn("Snapshot dependencies could not be found. Installing them.");
        this.clonePeass();
        this.installPeass();
    }

    private void clonePeass() throws InterruptedException, IOException {
        File logFile = new File(this.workspaceFolder, "clonePeassLog.txt");
        LOG.info("Cloning peass.");
        File parentFolder = this.workspaceFolder.getParentFile();
        File peassFolder = new File(parentFolder, "peass");
        if (!peassFolder.exists()) {
            ProcessBuilder builder = new ProcessBuilder("git", "clone", "--branch", "develop", "--progress", "https://github.com/DaGeRe/peass").directory(parentFolder);
            this.setRedirection(logFile, builder);
        } else {
            ProcessBuilder builder = new ProcessBuilder("git", "pull").directory(peassFolder);
            this.setRedirection(logFile, builder);
        }
    }

    private static String getMavenCall() {
        String mvnCall = !System.getProperty("os.name").startsWith("Windows") ? "./mvnw" : "mvnw.cmd";
        return mvnCall;
    }

    private void installPeass() throws InterruptedException, IOException {
        File logFile = new File(this.workspaceFolder, "installPeassLog.txt");
        LOG.info("Installing peass.");
        String mavenWrapperName = SnapshotDependencyChecker.getMavenCall();
        File directory = new File(this.workspaceFolder.getParentFile(), "peass");
        ProcessBuilder builder = new ProcessBuilder(mavenWrapperName, "install", "-DskipTests").directory(directory);
        builder.environment().put("MAVEN_CONFIG", "");
        this.setRedirection(logFile, builder);
    }

    private ProcessBuilder setRedirection(File logFile, ProcessBuilder builder) throws InterruptedException, IOException {
        if (this.measurementConfig.getExecutionConfig().isRedirectSubprocessOutputToFile()) {
            LOG.debug("Log goes to {}", (Object)logFile.getAbsolutePath());
            builder = builder.redirectOutput(logFile).redirectError(logFile);
            builder.start().waitFor();
        } else {
            LOG.debug("Not redirecting subprocess output to file, instead inheriting");
            builder.redirectErrorStream(true);
            Process process = builder.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    this.output.println(line);
                }
                process.waitFor();
            }
        }
        return builder;
    }
}

