/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.rts;

import de.dagere.peass.ci.Messages;
import de.dagere.peass.ci.VisibleAction;
import de.dagere.peass.ci.logs.rts.RTSLogSummary;
import de.dagere.peass.ci.rts.LineUtil;
import de.dagere.peass.config.TestSelectionConfig;
import de.dagere.peass.dependency.traces.coverage.CoverageSelectionCommit;
import io.jenkins.cli.shaded.org.jvnet.localizer.ResourceBundleHolder;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RTSVisualizationAction
extends VisibleAction {
    private static final ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);
    private final TestSelectionConfig config;
    private final Map<String, List<String>> staticSelection;
    private final List<String> dynamicSelection;
    private final String version;
    private final String versionOld;
    private final RTSLogSummary logSummary;
    private final CoverageSelectionCommit coverageSelection;

    public RTSVisualizationAction(int id, TestSelectionConfig config, Map<String, List<String>> staticSelection, List<String> dynamicSelection, CoverageSelectionCommit coverageSelection, String version, String versionOld, RTSLogSummary logSummary) {
        super(id);
        this.config = config;
        this.staticSelection = staticSelection;
        this.dynamicSelection = dynamicSelection;
        this.coverageSelection = coverageSelection;
        this.version = version;
        this.versionOld = versionOld;
        this.logSummary = logSummary;
    }

    public TestSelectionConfig getConfig() {
        return this.config;
    }

    public Map<String, List<String>> getStaticSelection() {
        return this.staticSelection;
    }

    public Map<List<String>, List<List<String>>> getStaticSelectionPrintable() {
        LinkedHashMap<List<String>, List<List<String>>> printableSelection = new LinkedHashMap<List<String>, List<List<String>>>();
        for (Map.Entry<String, List<String>> originalSelectionEntry : this.staticSelection.entrySet()) {
            List<String> key = LineUtil.createPrintable(originalSelectionEntry.getKey());
            LinkedList<List<String>> testcases = new LinkedList<List<String>>();
            for (String originalTestcase : originalSelectionEntry.getValue()) {
                List<String> printableTestcase = LineUtil.createPrintable(originalTestcase);
                testcases.add(printableTestcase);
            }
            printableSelection.put(key, testcases);
        }
        return printableSelection;
    }

    public List<String> getDynamicSelection() {
        return this.dynamicSelection;
    }

    public CoverageSelectionCommit getCoveragebasedSelection() {
        return this.coverageSelection;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVersionOld() {
        return this.versionOld;
    }

    public RTSLogSummary getLogSummary() {
        return this.logSummary;
    }

    public String getIconFileName() {
        return "/plugin/peass-ci/images/rts.png";
    }

    public String getDisplayName() {
        return Messages.RTSVisualizationAction_DisplayName();
    }

    public String getUrlName() {
        return "rtsResults_" + this.id;
    }
}

