/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.ci.rts;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import de.dagere.peass.ci.PeassProcessConfiguration;
import de.dagere.peass.ci.helper.IdHelper;
import de.dagere.peass.ci.logs.rts.RTSLogSummary;
import de.dagere.peass.ci.rts.RTSTraceAction;
import de.dagere.peass.ci.rts.RTSVisualizationAction;
import de.dagere.peass.config.FixedCommitConfig;
import de.dagere.peass.dependency.analysis.data.ChangedEntity;
import de.dagere.peass.dependency.analysis.data.TestCase;
import de.dagere.peass.dependency.analysis.data.TestSet;
import de.dagere.peass.dependency.analysis.testData.TestMethodCall;
import de.dagere.peass.dependency.persistence.CommitStaticSelection;
import de.dagere.peass.dependency.persistence.ExecutionData;
import de.dagere.peass.dependency.persistence.StaticTestSelection;
import de.dagere.peass.dependency.traces.coverage.CoverageSelectionCommit;
import de.dagere.peass.dependency.traces.coverage.CoverageSelectionInfo;
import de.dagere.peass.dependency.traces.diff.TraceFileUtil;
import de.dagere.peass.folders.ResultsFolders;
import de.dagere.peass.utils.Constants;
import hudson.model.Action;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RTSVisualizationCreator {
    private static final Logger LOG = LogManager.getLogger(RTSVisualizationCreator.class);
    private final ResultsFolders localWorkspace;
    private final PeassProcessConfiguration peassConfig;

    public RTSVisualizationCreator(ResultsFolders localWorkspace, PeassProcessConfiguration peassConfig) {
        this.localWorkspace = localWorkspace;
        this.peassConfig = peassConfig;
    }

    public void visualize(Run<?, ?> run, RTSLogSummary logSummary) {
        try {
            Map<String, List<String>> staticSelection = this.readStaticSelection(run);
            List<String> traceSelectedTests = this.readTraceBasedSelection(run);
            CoverageSelectionCommit coverageSelectedTests = this.readCoverageSelection(run);
            System.out.println("Selected: " + traceSelectedTests + " Coverage: " + coverageSelectedTests);
            FixedCommitConfig fixedCommitConfig = this.peassConfig.getMeasurementConfig().getFixedCommitConfig();
            RTSVisualizationAction rtsVisualizationAction = new RTSVisualizationAction(IdHelper.getId(), this.peassConfig.getDependencyConfig(), staticSelection, traceSelectedTests, coverageSelectedTests, fixedCommitConfig.getCommit(), fixedCommitConfig.getCommitOld(), logSummary);
            run.addAction((Action)rtsVisualizationAction);
            for (String traceSelectedTest : traceSelectedTests) {
                this.visualizeTest(run, traceSelectedTest);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void visualizeTest(Run<?, ?> run, String traceSelectedTest) throws IOException {
        TestMethodCall testcase = TestMethodCall.createFromString((String)traceSelectedTest);
        File traceFolder = this.localWorkspace.getVersionDiffFolder(this.peassConfig.getMeasurementConfig().getFixedCommitConfig().getCommit());
        String traceSource = this.readText(testcase, traceFolder);
        RTSTraceAction traceAction = new RTSTraceAction(IdHelper.getId(), traceSelectedTest, traceSource);
        run.addAction((Action)traceAction);
    }

    private String readText(TestMethodCall testcase, File traceFolder) throws IOException {
        File traceFile = new File(traceFolder, testcase.getShortClazz() + "#" + testcase.getMethod() + ".txt");
        System.out.println("Trace file: " + traceFile.getAbsolutePath());
        String traceSource = "";
        if (traceFile.exists()) {
            traceSource = TraceFileUtil.getText((File)traceFile).stream().collect(Collectors.joining("\n"));
        } else {
            File zipTraceFile = new File(traceFolder, testcase.getShortClazz() + "#" + testcase.getMethod() + ".zip");
            if (zipTraceFile.exists()) {
                traceSource = TraceFileUtil.getText((File)zipTraceFile).stream().collect(Collectors.joining("\n"));
            }
        }
        return traceSource;
    }

    private List<String> readTraceBasedSelection(Run<?, ?> run) throws IOException, JsonParseException, JsonMappingException {
        LinkedList<String> selectedTests = new LinkedList<String>();
        File traceTestSelectionFile = this.localWorkspace.getTraceTestSelectionFile();
        if (traceTestSelectionFile.exists()) {
            ExecutionData traceSelections = (ExecutionData)Constants.OBJECTMAPPER.readValue(traceTestSelectionFile, ExecutionData.class);
            TestSet tests = (TestSet)traceSelections.getCommits().get(this.peassConfig.getMeasurementConfig().getFixedCommitConfig().getCommit());
            if (tests != null) {
                for (TestCase test : tests.getTests()) {
                    selectedTests.add(test.toString());
                }
            }
        } else {
            LOG.info("File {} was not found, RTS execution info might be incomplete", (Object)traceTestSelectionFile.getAbsoluteFile());
        }
        return selectedTests;
    }

    private CoverageSelectionCommit readCoverageSelection(Run<?, ?> run) throws IOException, JsonParseException, JsonMappingException {
        File coverageInfoFile = this.localWorkspace.getCoverageInfoFile();
        if (coverageInfoFile.exists()) {
            LOG.info("Reading {}", (Object)coverageInfoFile);
            CoverageSelectionInfo executions = (CoverageSelectionInfo)Constants.OBJECTMAPPER.readValue(coverageInfoFile, CoverageSelectionInfo.class);
            CoverageSelectionCommit currentVersion = (CoverageSelectionCommit)executions.getVersions().get(this.peassConfig.getMeasurementConfig().getFixedCommitConfig().getCommit());
            return currentVersion;
        }
        LOG.info("File {} was not found, RTS coverage based selection info might be incomplete", (Object)coverageInfoFile.getAbsoluteFile());
        return null;
    }

    private Map<String, List<String>> readStaticSelection(Run<?, ?> run) throws IOException, JsonParseException, JsonMappingException {
        LinkedHashMap<String, List<String>> staticSelection = new LinkedHashMap<String, List<String>>();
        File staticSelectionFile = this.localWorkspace.getStaticTestSelectionFile();
        if (staticSelectionFile.exists()) {
            StaticTestSelection staticTestSelection = (StaticTestSelection)Constants.OBJECTMAPPER.readValue(staticSelectionFile, StaticTestSelection.class);
            CommitStaticSelection version = (CommitStaticSelection)staticTestSelection.getCommits().get(this.peassConfig.getMeasurementConfig().getFixedCommitConfig().getCommit());
            if (version != null) {
                this.addVersionDataToChangeliste(staticSelection, version);
            } else {
                LOG.info("No change has been detected in " + this.peassConfig.getMeasurementConfig().getFixedCommitConfig().getCommit());
            }
        } else {
            LOG.error("File {} was not found, RTS selection seems to not have worked at all", (Object)staticSelectionFile);
        }
        return staticSelection;
    }

    private void addVersionDataToChangeliste(Map<String, List<String>> changesList, CommitStaticSelection version) {
        for (Map.Entry entry : version.getChangedClazzes().entrySet()) {
            LinkedList<String> tests = new LinkedList<String>();
            for (TestCase test : ((TestSet)entry.getValue()).getTests()) {
                tests.add(test.toString());
            }
            ChangedEntity changedClazz = (ChangedEntity)entry.getKey();
            changesList.put(changedClazz.toString(), tests);
        }
    }
}

