/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.gem;

import de.saumya.mojo.gem.AbstractGemMojo;
import de.saumya.mojo.ruby.gems.GemException;
import de.saumya.mojo.ruby.script.ScriptException;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="sets", defaultPhase=LifecyclePhase.INITIALIZE, requiresDependencyResolution=ResolutionScope.TEST)
public class SetsMojo
extends AbstractGemMojo {
    @Parameter(defaultValue="compile")
    protected String scope;
    @Parameter
    protected Map<String, String> gems = Collections.emptyMap();
    @Component
    protected ModelReader reader;

    @Override
    protected void executeWithGems() throws MojoExecutionException, ScriptException, IOException, GemException {
        TreeSet<Artifact> gems = new TreeSet<Artifact>();
        TreeSet<Artifact> jars = new TreeSet<Artifact>();
        for (Map.Entry<String, String> gem : this.gems.entrySet()) {
            Set set = this.manager.resolve(this.manager.createGemArtifact(gem.getKey(), gem.getValue()), this.localRepository, this.project.getRemoteArtifactRepositories());
            if (set.size() == 1) {
                Artifact artifact = (Artifact)set.iterator().next();
                artifact.setScope(this.scope);
                gems.add(artifact);
                this.collectJarDependencies(jars, artifact);
                continue;
            }
            if (set.size() <= 1) continue;
            this.getLog().error((CharSequence)("found more then one artifact for given version: " + gem.getKey() + " " + gem.getValue()));
        }
        this.resolveJarDepedencies(jars);
        this.installGems(gems);
        Set resolved = (Set)this.project.getContextValue("jruby.resolved.artifacts");
        if (resolved == null) {
            resolved = this.project.getArtifacts();
            this.project.setResolvedArtifacts(resolved);
            this.project.setContextValue("jruby.resolved.artifacts", (Object)resolved);
        }
        resolved.addAll(jars);
        resolved.addAll(gems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installGems(Set<Artifact> gems) throws IOException, ScriptException, GemException {
        File home = this.gemsConfig.getGemHome();
        String base = this.gemsConfig.getGemHome() != null ? this.gemsConfig.getGemHome().getAbsolutePath() : this.project.getBuild().getDirectory() + "/rubygems";
        try {
            File gemHome = "test".equals(this.scope) || "provided".equals(this.scope) ? this.gemHome(base, this.scope) : new File(base);
            this.gemsConfig.setGemHome(gemHome);
            this.gemsConfig.addGemPath(gemHome);
            this.getLog().info((CharSequence)("installing gem sets for " + this.scope + " scope into " + gemHome.getAbsolutePath().replace(this.project.getBasedir().getAbsolutePath() + File.separatorChar, "")));
            this.gemsInstaller.installGems(this.project, gems, null, (List)null);
        }
        finally {
            this.gemsConfig.setGemHome(home);
        }
    }

    private void collectJarDependencies(Set<Artifact> jars, Artifact artifact) throws GemException, IOException {
        Set set = this.manager.resolve(this.manager.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "pom"), this.localRepository, this.project.getRemoteArtifactRepositories());
        Model pom = this.reader.read(((Artifact)set.iterator().next()).getFile(), null);
        for (Dependency dependency : pom.getDependencies()) {
            if (dependency.getType().equals("gem") || dependency.getScope() != null && !dependency.getScope().equals("compile") && !dependency.getScope().equals("runtime")) continue;
            Artifact a = this.manager.createArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getClassifier(), dependency.getType());
            a.setScope(dependency.getScope());
            jars.add(a);
        }
    }

    private void resolveJarDepedencies(Set<Artifact> jars) {
        ArtifactResolutionRequest req = new ArtifactResolutionRequest().setArtifact(this.project.getArtifact()).setResolveRoot(false).setArtifactDependencies(jars).setResolveTransitively(true).setLocalRepository(this.localRepository).setRemoteRepositories(this.project.getRemoteArtifactRepositories()).setCollectionFilter(new ArtifactFilter(){

            public boolean include(Artifact artifact) {
                return !artifact.getGroupId().equals("org.jruby") || !artifact.getArtifactId().equals("jruby") && !artifact.getArtifactId().equals("jruby-complete") && !artifact.getArtifactId().equals("jruby-core") && !artifact.getArtifactId().equals("jruby-stdlib");
            }
        });
        ArtifactResolutionResult result = this.repositorySystem.resolve(req);
        Set resolvedArtifacts = result.getArtifacts();
        for (Artifact artifact : resolvedArtifacts) {
            if ("compile".equals(this.scope)) {
                if (artifact.getScope() == null) {
                    artifact.setScope(this.scope);
                }
                jars.add(artifact);
                continue;
            }
            if ("test".equals(artifact.getScope()) || "provided".equals(artifact.getScope())) continue;
            artifact.setScope(this.scope);
            jars.add(artifact);
        }
    }
}

