/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.crypto.raes;

import de.schlichtherle.truezip.crypto.BufferedPartialBlockCipher;
import de.schlichtherle.truezip.crypto.SICSeekableBlockCipher;
import de.schlichtherle.truezip.crypto.raes.RaesOutputStream;
import de.schlichtherle.truezip.crypto.raes.Type0RaesParameters;
import de.schlichtherle.truezip.io.LEDataOutputStream;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.bouncycastle.crypto.io.MacOutputStream;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.io.TeeOutputStream;

@NotThreadSafe
final class Type0RaesOutputStream
extends RaesOutputStream {
    static final int ITERATION_COUNT = 2005;
    private final SecureRandom shaker = new SecureRandom();
    private final Type0RaesParameters.KeyStrength keyStrength;
    private final Mac mac;
    private final Mac klac;
    private final LEDataOutputStream dos;
    private long start;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    Type0RaesOutputStream(@WillCloseWhenClosed OutputStream out, Type0RaesParameters param) throws IOException {
        super(out, (BufferedBlockCipher)new BufferedPartialBlockCipher((BlockCipher)new SICSeekableBlockCipher((BlockCipher)new AESFastEngine())));
        assert (null != out);
        assert (null != param);
        Type0RaesParameters.KeyStrength keyStrength = param.getKeyStrength();
        int keyStrengthOrdinal = keyStrength.ordinal();
        int keyStrengthBits = keyStrength.getBits();
        int keyStrengthBytes = keyStrength.getBytes();
        this.keyStrength = keyStrength;
        byte[] salt = new byte[keyStrengthBytes];
        this.shaker.nextBytes(salt);
        SHA256Digest digest = new SHA256Digest();
        assert (digest.getDigestSize() >= keyStrengthBytes);
        char[] pwdChars = param.getWritePassword();
        byte[] pwdBytes = PBEParametersGenerator.PKCS12PasswordToBytes((char[])pwdChars);
        this.paranoidWipe(pwdChars);
        PKCS12ParametersGenerator gen = new PKCS12ParametersGenerator((Digest)digest);
        gen.init(pwdBytes, salt, 2005);
        ParametersWithIV aesCtrParam = (ParametersWithIV)gen.generateDerivedParameters(keyStrengthBits, 128);
        CipherParameters sha256HMmacParam = gen.generateDerivedMacParameters(keyStrengthBits);
        this.paranoidWipe(pwdBytes);
        this.cipher.init(true, (CipherParameters)aesCtrParam);
        this.mac = new HMac((Digest)digest);
        HMac mac = this.mac;
        mac.init(sha256HMmacParam);
        this.klac = new HMac((Digest)new SHA256Digest());
        HMac klac = this.klac;
        klac.init(sha256HMmacParam);
        byte[] cipherKey = ((KeyParameter)aesCtrParam.getParameters()).getKey();
        klac.update(cipherKey, 0, cipherKey.length);
        this.dos = out instanceof LEDataOutputStream ? (LEDataOutputStream)out : new LEDataOutputStream(out);
        LEDataOutputStream dos = this.dos;
        this.delegate = new TeeOutputStream((OutputStream)dos, (OutputStream)new MacOutputStream((Mac)mac));
        dos.writeInt(1397047634);
        dos.writeByte(0);
        dos.writeByte(keyStrengthOrdinal);
        dos.writeShort(2005);
        dos.write(salt);
        this.start = dos.size();
        assert ((long)(8 + salt.length) == this.start);
    }

    private void paranoidWipe(byte[] passwd) {
        this.shaker.nextBytes(passwd);
    }

    private void paranoidWipe(char[] passwd) {
        SecureRandom rng = this.shaker;
        int i = passwd.length;
        while (--i >= 0) {
            passwd[i] = (char)rng.nextInt();
        }
    }

    @Override
    public Type0RaesParameters.KeyStrength getKeyStrength() {
        return this.keyStrength;
    }

    protected void finish() throws IOException {
        super.finish();
        long trailer = this.dos.size();
        Mac mac = this.mac;
        assert (mac.getMacSize() == this.klac.getMacSize());
        byte[] buf = new byte[mac.getMacSize()];
        long length = trailer - this.start;
        Type0RaesOutputStream.klac(this.klac, length, buf);
        this.dos.write(buf, 0, buf.length / 2);
        int bufLength = mac.doFinal(buf, 0);
        assert (bufLength == buf.length);
        this.dos.write(buf, 0, buf.length / 2);
        assert (this.dos.size() - trailer == (long)buf.length);
    }
}

