/*
 * Decompiled with CFR 0.152.
 */
package digital.pragmatech.testing;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class SpringContextStatistics {
    private final AtomicInteger contextLoads = new AtomicInteger(0);
    private final AtomicInteger cacheHits = new AtomicInteger(0);
    private final AtomicInteger cacheMisses = new AtomicInteger(0);
    private final List<ContextLoadEvent> contextLoadEvents = new CopyOnWriteArrayList<ContextLoadEvent>();
    private final Map<String, Set<String>> cacheKeyToTestClasses = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, CacheKeyInfo> cacheKeyInfoMap = new ConcurrentHashMap<String, CacheKeyInfo>();

    public void recordContextLoad(String contextKey, Duration loadTime) {
        this.recordContextLoad(contextKey, loadTime, null);
    }

    public void recordContextLoad(String contextKey, Duration loadTime, String testClassName) {
        this.contextLoads.incrementAndGet();
        this.cacheMisses.incrementAndGet();
        this.contextLoadEvents.add(new ContextLoadEvent(contextKey, loadTime, Instant.now()));
        this.recordCacheKeyUsage(contextKey, testClassName, false);
    }

    public void recordCacheHit(String contextKey) {
        this.recordCacheHit(contextKey, null);
    }

    public void recordCacheHit(String contextKey, String testClassName) {
        this.cacheHits.incrementAndGet();
        this.recordCacheKeyUsage(contextKey, testClassName, true);
    }

    private synchronized void recordCacheKeyUsage(String contextKey, String testClassName, boolean wasHit) {
        if (contextKey == null) {
            return;
        }
        this.cacheKeyToTestClasses.computeIfAbsent(contextKey, k -> ConcurrentHashMap.newKeySet());
        if (testClassName != null) {
            this.cacheKeyToTestClasses.get(contextKey).add(testClassName);
        }
        CacheKeyInfo info = this.cacheKeyInfoMap.computeIfAbsent(contextKey, k -> new CacheKeyInfo((String)k));
        if (wasHit) {
            info.incrementHits();
        } else {
            info.incrementMisses();
        }
    }

    public int getContextLoads() {
        return this.contextLoads.get();
    }

    public int getCacheHits() {
        return this.cacheHits.get();
    }

    public int getCacheMisses() {
        return this.cacheMisses.get();
    }

    public double getCacheHitRate() {
        int misses;
        int hits = this.cacheHits.get();
        int totalAccesses = hits + (misses = this.cacheMisses.get());
        return totalAccesses > 0 ? (double)hits / (double)totalAccesses * 100.0 : 0.0;
    }

    public List<ContextLoadEvent> getContextLoadEvents() {
        return new ArrayList<ContextLoadEvent>(this.contextLoadEvents);
    }

    public Duration getTotalContextLoadTime() {
        return this.contextLoadEvents.stream().map(ContextLoadEvent::getLoadTime).reduce(Duration.ZERO, Duration::plus);
    }

    public Map<String, Set<String>> getCacheKeyToTestClasses() {
        return new HashMap<String, Set<String>>(this.cacheKeyToTestClasses);
    }

    public Map<String, CacheKeyInfo> getCacheKeyInfoMap() {
        return new HashMap<String, CacheKeyInfo>(this.cacheKeyInfoMap);
    }

    public static class ContextLoadEvent {
        private final String contextKey;
        private final Duration loadTime;
        private final Instant timestamp;

        public ContextLoadEvent(String contextKey, Duration loadTime, Instant timestamp) {
            this.contextKey = contextKey;
            this.loadTime = loadTime;
            this.timestamp = timestamp;
        }

        public String getContextKey() {
            return this.contextKey;
        }

        public Duration getLoadTime() {
            return this.loadTime;
        }

        public Instant getTimestamp() {
            return this.timestamp;
        }
    }

    public static class CacheKeyInfo {
        private final String cacheKey;
        private final AtomicInteger hits = new AtomicInteger(0);
        private final AtomicInteger misses = new AtomicInteger(0);

        public CacheKeyInfo(String cacheKey) {
            this.cacheKey = cacheKey;
        }

        public void incrementHits() {
            this.hits.incrementAndGet();
        }

        public void incrementMisses() {
            this.misses.incrementAndGet();
        }

        public String getCacheKey() {
            return this.cacheKey;
        }

        public int getHits() {
            return this.hits.get();
        }

        public int getMisses() {
            return this.misses.get();
        }

        public int getTotalAccesses() {
            return this.hits.get() + this.misses.get();
        }

        public double getHitRate() {
            int m;
            int h = this.hits.get();
            int total = h + (m = this.misses.get());
            return total > 0 ? (double)h / (double)total * 100.0 : 0.0;
        }
    }
}

