/*
 * Decompiled with CFR 0.152.
 */
package digital.pragmatech.testing.diagnostic;

import digital.pragmatech.testing.diagnostic.ContextDiagnostic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.Order;

@Order(value=-2147483648)
public class ContextDiagnosticApplicationInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final Logger LOG = LoggerFactory.getLogger(ContextDiagnosticApplicationInitializer.class);

    public void initialize(ConfigurableApplicationContext applicationContext) {
        ContextDiagnostic contextDiagnostic = ContextDiagnostic.started();
        applicationContext.addApplicationListener(event -> {
            ContextRefreshedEvent contextEvent;
            if (event instanceof ContextRefreshedEvent && (contextEvent = (ContextRefreshedEvent)event).getApplicationContext().getParent() == null && !applicationContext.getBeanFactory().containsSingleton("contextDiagnostic")) {
                ContextDiagnostic completedDiagnostic = contextDiagnostic.completed();
                applicationContext.getBeanFactory().registerSingleton("contextDiagnostic", (Object)completedDiagnostic);
                LOG.debug("Context Diagnostic Completed: {}", (Object)completedDiagnostic);
            }
        });
    }

    public boolean equals(Object that) {
        return this.getClass() == that.getClass();
    }

    public int hashCode() {
        return 0;
    }
}

