/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.enav.util;

public final class CoordinateConverter {
    private static final double RADIUS = 6356752.3;
    private final double lon0;
    private final double lat0;
    private final double lon0Rad;
    private final double lat0Rad;

    public CoordinateConverter(double centralLongitude, double centralLatitude) {
        this.lon0 = centralLongitude;
        this.lat0 = centralLatitude;
        this.lon0Rad = StrictMath.toRadians(centralLongitude);
        this.lat0Rad = StrictMath.toRadians(centralLatitude);
    }

    public double lon2x(double lon, double lat) {
        double lonRad = StrictMath.toRadians(lon);
        double latRad = StrictMath.toRadians(lat);
        double x = 0.0;
        double denom = 1.0 + StrictMath.sin(this.lat0Rad) * StrictMath.sin(latRad) + StrictMath.cos(this.lat0Rad) * StrictMath.cos(latRad) * StrictMath.cos(lonRad - this.lon0Rad);
        if (denom != 0.0) {
            x = 1.27135046E7 / denom * StrictMath.cos(latRad) * StrictMath.sin(lonRad - this.lon0Rad);
        }
        return x;
    }

    public double lat2y(double lon, double lat) {
        double lonRad = StrictMath.toRadians(lon);
        double latRad = StrictMath.toRadians(lat);
        double y = 0.0;
        double denom = 1.0 + StrictMath.sin(this.lat0Rad) * StrictMath.sin(latRad) + StrictMath.cos(this.lat0Rad) * StrictMath.cos(latRad) * StrictMath.cos(lonRad - this.lon0Rad);
        if (denom != 0.0) {
            y = 1.27135046E7 / denom * (StrictMath.cos(this.lat0Rad) * StrictMath.sin(latRad) - StrictMath.sin(this.lat0Rad) * StrictMath.cos(latRad) * StrictMath.cos(lonRad - this.lon0Rad));
        }
        return y;
    }

    public double x2Lon(double x, double y) {
        double ro = StrictMath.sqrt(x * x + y * y);
        double c = 2.0 * StrictMath.atan(ro / 1.27135046E7);
        double denom = ro * StrictMath.cos(this.lat0Rad) * StrictMath.cos(c) - y * StrictMath.sin(this.lat0Rad) * StrictMath.sin(c);
        double lon = this.lon0;
        if (denom != 0.0) {
            lon = this.lon0Rad + StrictMath.atan(x * StrictMath.sin(c) / denom);
            lon = StrictMath.toDegrees(lon);
        }
        return lon;
    }

    public double y2Lat(double x, double y) {
        double lat = this.lat0;
        double ro = StrictMath.sqrt(x * x + y * y);
        if (ro != 0.0) {
            double c = 2.0 * StrictMath.atan(ro / 1.27135046E7);
            lat = StrictMath.asin(StrictMath.cos(c) * StrictMath.sin(this.lat0Rad) + y * StrictMath.sin(c) * StrictMath.cos(this.lat0Rad) / ro);
            lat = StrictMath.toDegrees(lat);
        }
        return lat;
    }
}

