/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.enav.util.function;

import java.util.Objects;
import java.util.function.Predicate;

public abstract class EConsumer<T> {
    public abstract void accept(T var1) throws Exception;

    public EConsumer<T> chain(final EConsumer<? super T> other) {
        Objects.requireNonNull(other);
        return new EConsumer<T>(){

            @Override
            public void accept(T t) throws Exception {
                EConsumer.this.accept(t);
                other.accept(t);
            }
        };
    }

    public EConsumer<T> filter(final Predicate<T> filter) {
        Objects.requireNonNull(filter);
        return new EConsumer<T>(){

            @Override
            public void accept(T t) throws Exception {
                if (filter.test(t)) {
                    EConsumer.this.accept(t);
                }
            }
        };
    }
}

