/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.plugin;

import edu.berkeley.cs.jqf.fuzz.guidance.Guidance;
import edu.berkeley.cs.jqf.fuzz.junit.GuidedFuzzing;
import edu.berkeley.cs.jqf.fuzz.repro.ReproGuidance;
import edu.berkeley.cs.jqf.instrument.InstrumentingClassLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.junit.runner.Result;

@Mojo(name="repro", requiresDependencyResolution=ResolutionScope.TEST)
public class ReproGoal
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File target;
    @Parameter(property="class", required=true)
    private String testClassName;
    @Parameter(property="method", required=true)
    private String testMethod;
    @Parameter(property="input", required=true)
    private String input;
    @Parameter(property="logCoverage")
    private String logCoverage;
    @Parameter(property="excludes")
    private String excludes;
    @Parameter(property="includes")
    private String includes;
    @Parameter(property="printArgs")
    private boolean printArgs;
    @Parameter(property="dumpArgsDir")
    private String dumpArgsDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Result result;
        ReproGuidance guidance;
        File inputFile;
        InstrumentingClassLoader loader;
        Log log = this.getLog();
        PrintStream out = System.out;
        if (this.excludes != null) {
            System.setProperty("janala.excludes", this.excludes);
        }
        if (this.includes != null) {
            System.setProperty("janala.includes", this.includes);
        }
        try {
            List classpathElements = this.project.getTestClasspathElements();
            loader = new InstrumentingClassLoader(classpathElements.toArray(new String[0]), ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (MalformedURLException | DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Could not get project classpath", (Exception)e);
        }
        if (this.logCoverage != null) {
            System.setProperty("jqf.repro.logUniqueBranches", "true");
        }
        if (this.printArgs) {
            System.setProperty("jqf.repro.printArgs", "true");
        }
        if (this.dumpArgsDir != null) {
            System.setProperty("jqf.repro.dumpArgsDir", this.dumpArgsDir);
        }
        if (!(inputFile = new File(this.input)).exists() || !inputFile.canRead()) {
            throw new MojoExecutionException("Cannot find or open file " + this.input);
        }
        try {
            guidance = new ReproGuidance(inputFile, null);
            result = GuidedFuzzing.run((String)this.testClassName, (String)this.testMethod, (ClassLoader)loader, (Guidance)guidance, (PrintStream)out);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Could not load test class", (Exception)e);
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException("Bad request", (Exception)e);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("File not found", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("I/O error", (Exception)e);
        }
        catch (RuntimeException e) {
            throw new MojoExecutionException("Internal error", (Exception)e);
        }
        if (this.logCoverage != null) {
            Set coverageSet = guidance.getBranchesCovered();
            assert (coverageSet != null);
            TreeSet sortedCoverage = new TreeSet(coverageSet);
            try (PrintWriter covOut = new PrintWriter(new File(this.logCoverage));){
                for (String b : sortedCoverage) {
                    covOut.println(b);
                }
            }
            catch (IOException e) {
                log.error((CharSequence)"Could not dump coverage info.", (Throwable)e);
            }
        }
        if (!result.wasSuccessful()) {
            throw new MojoFailureException("Test case produces a failure.");
        }
    }
}

