/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.assertj;

import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import java.util.Objects;
import org.assertj.core.api.AbstractAssert;

public class IssuesAssert
extends AbstractAssert<IssuesAssert, Report> {
    private static final String EXPECTED_BUT_WAS_MESSAGE = "%nExpecting %s of:%n <%s>%nto be:%n <%s>%nbut was:%n <%s>.";

    public IssuesAssert(Report actual) {
        super((Object)actual, IssuesAssert.class);
    }

    public static IssuesAssert assertThat(Report actual) {
        return new IssuesAssert(actual);
    }

    public IssuesAssert isEmpty() {
        this.isNotNull();
        if (!((Report)this.actual).isEmpty()) {
            this.failWithMessage(EXPECTED_BUT_WAS_MESSAGE, new Object[]{"empty issues", this.actual, "empty", "not empty"});
        }
        return this;
    }

    public IssuesAssert hasId(String origin) {
        this.isNotNull();
        if (!Objects.equals(((Report)this.actual).getId(), origin)) {
            this.failWithMessage(EXPECTED_BUT_WAS_MESSAGE, new Object[]{"origin", this.actual, origin, ((Report)this.actual).getId()});
        }
        return this;
    }

    public IssuesAssert hasReference(String reference) {
        this.isNotNull();
        if (!Objects.equals(((Report)this.actual).getReference(), reference)) {
            this.failWithMessage(EXPECTED_BUT_WAS_MESSAGE, new Object[]{"reference", this.actual, reference, ((Report)this.actual).getReference()});
        }
        return this;
    }

    public IssuesAssert hasSize(int size) {
        this.isNotNull();
        if (((Report)this.actual).getSize() != size) {
            this.failWithMessage(EXPECTED_BUT_WAS_MESSAGE, new Object[]{"size", this.actual, size, ((Report)this.actual).size()});
        }
        return this;
    }

    public IssuesAssert hasDuplicatesSize(int size) {
        this.isNotNull();
        if (((Report)this.actual).getDuplicatesSize() != size) {
            this.failWithMessage(EXPECTED_BUT_WAS_MESSAGE, new Object[]{"duplicates size", this.actual, size, ((Report)this.actual).getDuplicatesSize()});
        }
        return this;
    }

    public IssuesAssert hasSeverities(int expectedSizeError, int expectedSizeHigh, int expectedSizeNormal, int expectedSizeLow) {
        this.isNotNull();
        if (((Report)this.actual).getSizeOf(Severity.ERROR) != expectedSizeError) {
            this.failWithMessage(EXPECTED_BUT_WAS_MESSAGE, new Object[]{"expectedSizeError", this.actual, expectedSizeError, ((Report)this.actual).getSizeOf(Severity.ERROR)});
        }
        if (((Report)this.actual).getSizeOf(Severity.WARNING_HIGH) != expectedSizeHigh) {
            this.failWithMessage(EXPECTED_BUT_WAS_MESSAGE, new Object[]{"expectedSizeHigh", this.actual, expectedSizeHigh, ((Report)this.actual).getSizeOf(Severity.WARNING_HIGH)});
        }
        if (((Report)this.actual).getSizeOf(Severity.WARNING_NORMAL) != expectedSizeNormal) {
            this.failWithMessage(EXPECTED_BUT_WAS_MESSAGE, new Object[]{"expectedSizeNormal", this.actual, expectedSizeNormal, ((Report)this.actual).getSizeOf(Severity.WARNING_NORMAL)});
        }
        if (((Report)this.actual).getSizeOf(Severity.WARNING_LOW) != expectedSizeLow) {
            this.failWithMessage(EXPECTED_BUT_WAS_MESSAGE, new Object[]{"expectedSizeLow", this.actual, expectedSizeLow, ((Report)this.actual).getSizeOf(Severity.WARNING_LOW)});
        }
        return this;
    }
}

